test_that("countInteractions function works", {
    library(cytomapper)
    data(pancreasSCE)
    
    pancreasSCE <- buildSpatialGraph(pancreasSCE, img_id = "ImageNb", type = "knn",
                                     k = 3)
    
    ########################### classic ############################

    expect_silent(cur_out <- countInteractions(pancreasSCE, group_by = "ImageNb",
                                                   label = "CellType", method = "classic",
                                                   colPairName = "knn_interaction_graph")) 
    cur_out <- as.data.frame(cur_out)
    cur_out <- cur_out[order(cur_out$group_by, cur_out$from_label, cur_out$to_label),]
    
    # Check against manual calculations
    cur_table <- as.data.frame(colPair(pancreasSCE, "knn_interaction_graph"))
    cur_table$from_label <- colData(pancreasSCE)[["CellType"]][cur_table$from]
    cur_table$to_label <- colData(pancreasSCE)[["CellType"]][cur_table$to]
    cur_table$image <- colData(pancreasSCE)[["ImageNb"]][cur_table$from]
    
    test <- cur_table %>% group_by(from, image, from_label) %>%
        count(as.factor(to_label), .drop = FALSE) %>% ungroup() %>% 
        group_by(image, from_label, `as.factor(to_label)`) %>% summarize(ct = mean(n))
    
    test <- as.data.frame(test)
    test <- test[order(test$image, test$from_label, test$`as.factor(to_label)`),]
    
    cur_out_2 <- cur_out
    cur_out_2 <- cur_out_2[match(paste(test$image, test$from_label, test$`as.factor(to_label)`),
                                 paste(cur_out_2$group_by, cur_out_2$from_label, cur_out_2$to_label)),]

    expect_equal(cur_out_2$ct[!is.na(cur_out_2$ct)], test$ct[!is.na(cur_out_2$ct)])   

    # As factor
    pancreasSCE$CellType <- as.factor(pancreasSCE$CellType)
    expect_silent(cur_out_2 <- countInteractions(pancreasSCE, group_by = "ImageNb",
                                                   label = "CellType", method = "classic",
                                                   colPairName = "knn_interaction_graph")) 
    cur_out_2 <- as.data.frame(cur_out_2)
    cur_out_2 <- cur_out_2[order(cur_out_2$group_by, cur_out_2$from_label, cur_out_2$to_label),]
        
    expect_equal(cur_out_2$ct, cur_out$ct)
    
    # As character
    pancreasSCE$CellType <- as.character(pancreasSCE$CellType)
    expect_silent(cur_out_2 <- countInteractions(pancreasSCE, group_by = "ImageNb",
                                                     label = "CellType", method = "classic",
                                                     colPairName = "knn_interaction_graph")) 
    cur_out_2 <- as.data.frame(cur_out_2)
    cur_out_2 <- cur_out_2[order(cur_out_2$group_by, cur_out_2$from_label, cur_out_2$to_label),]
    
    expect_equal(cur_out_2, cur_out)
    
    # As numeric
    pancreasSCE$CellType <- as.numeric(as.factor(pancreasSCE$CellType))
    expect_silent(cur_out_2 <- countInteractions(pancreasSCE, group_by = "ImageNb",
                                                     label = "CellType", method = "classic",
                                                     colPairName = "knn_interaction_graph")) 
    cur_out_2 <- as.data.frame(cur_out_2)
    cur_out_2 <- cur_out_2[order(cur_out_2$group_by, cur_out_2$from_label, cur_out_2$to_label),]
    
    expect_equal(cur_out_2$ct, cur_out$ct)
    
    # Logical
    expect_silent(cur_out_2 <- countInteractions(pancreasSCE, group_by = "ImageNb",
                                                   label = "Pattern", method = "classic",
                                                   colPairName = "knn_interaction_graph")) 

    cur_out_2 <- as.data.frame(cur_out_2)
    cur_out_2 <- cur_out_2[order(cur_out_2$group_by, cur_out_2$from_label, cur_out_2$to_label),]
    
    cur_table <- as.data.frame(colPair(pancreasSCE, "knn_interaction_graph"))
    cur_table$from_label <- colData(pancreasSCE)[["Pattern"]][cur_table$from]
    cur_table$to_label <- colData(pancreasSCE)[["Pattern"]][cur_table$to]
    cur_table$image <- colData(pancreasSCE)[["ImageNb"]][cur_table$from]
    
    test <- cur_table %>% group_by(from, image, from_label) %>%
        count(as.factor(to_label), .drop = FALSE) %>% ungroup() %>% 
        group_by(image, from_label, `as.factor(to_label)`) %>% summarize(ct = mean(n))
    
    expect_equal(cur_out_2$ct[!is.na(cur_out_2$ct)], test$ct[!is.na(cur_out_2$ct)]) 
    
    # One image only contains one cell type
    data(pancreasSCE)
    
    pancreasSCE <- buildSpatialGraph(pancreasSCE, img_id = "ImageNb", type = "knn",
                                     k = 3)
    
    pancreasSCE$test <- pancreasSCE$CellType
    pancreasSCE$test[pancreasSCE$ImageNb == 3] <- "test" 
    expect_silent(cur_out_3 <- countInteractions(pancreasSCE, group_by = "ImageNb",
                                                   label = "test", method = "classic",
                                                   colPairName = "knn_interaction_graph")) 
    
    cur_out_3 <- as.data.frame(cur_out_3)
    cur_out_3 <- cur_out_3[order(cur_out_3$group_by, cur_out_3$from_label, cur_out_3$to_label),]
    
    cur_table <- as.data.frame(colPair(pancreasSCE, "knn_interaction_graph"))
    cur_table$from_label <- colData(pancreasSCE)[["test"]][cur_table$from]
    cur_table$to_label <- colData(pancreasSCE)[["test"]][cur_table$to]
    cur_table$image <- colData(pancreasSCE)[["ImageNb"]][cur_table$from]
    
    test <- cur_table %>% group_by(from, image, from_label) %>%
        count(as.factor(to_label), .drop = FALSE) %>% ungroup() %>% 
        group_by(image, from_label, `as.factor(to_label)`) %>% summarize(ct = mean(n))
    
    cur_out_4 <- cur_out_3
    cur_out_4 <- cur_out_4[match(paste(test$image, test$from_label, test$`as.factor(to_label)`),
                                 paste(cur_out_4$group_by, cur_out_4$from_label, cur_out_4$to_label)),]
    
    expect_equal(cur_out_4$ct[!is.na(cur_out_4$ct)], test$ct[!is.na(cur_out_4$ct)]) 
    expect_equal(cur_out_3$ct[!is.na(cur_out_3$ct) & cur_out_3$group_by != 3], cur_out$ct[!is.na(cur_out$ct) & cur_out$group_by != 3]) 
    
    data(pancreasSCE)
    pancreasSCE <- buildSpatialGraph(pancreasSCE, img_id = "ImageNb", type = "knn",
                                     k = 3)
    pancreasSCE$ImageName <- "test"
    
    expect_silent(cur_out <- countInteractions(pancreasSCE, group_by = "ImageName",
                                                   label = "CellType", method = "classic",
                                                   colPairName = "knn_interaction_graph")) 
    
    cur_table <- as.data.frame(colPair(pancreasSCE, "knn_interaction_graph"))
    cur_table$from_label <- colData(pancreasSCE)[["CellType"]][cur_table$from]
    cur_table$to_label <- colData(pancreasSCE)[["CellType"]][cur_table$to]
    cur_table$image <- colData(pancreasSCE)[["ImageName"]][cur_table$from]
    
    test <- cur_table %>% group_by(from, image, from_label) %>%
        count(as.factor(to_label), .drop = FALSE) %>% ungroup() %>% 
        group_by(image, from_label, `as.factor(to_label)`) %>% summarize(ct = mean(n))
    
    expect_equal(cur_out$ct, test$ct)
    
    ########################### conditional ############################
    data(pancreasSCE)
    
    pancreasSCE <- buildSpatialGraph(pancreasSCE, img_id = "ImageNb", type = "knn",
                                     k = 3)
    
    expect_silent(cur_out <- countInteractions(pancreasSCE, group_by = "ImageNb",
                                                   label = "CellType", method = "conditional",
                                                   colPairName = "knn_interaction_graph")) 
    
    cur_out <- as.data.frame(cur_out)
    cur_out <- cur_out[order(cur_out$group_by, cur_out$from_label, cur_out$to_label),]
    
    cur_table <- as.data.frame(colPair(pancreasSCE, "knn_interaction_graph"))
    cur_table$from_label <- colData(pancreasSCE)[["CellType"]][cur_table$from]
    cur_table$to_label <- colData(pancreasSCE)[["CellType"]][cur_table$to]
    cur_table$image <- colData(pancreasSCE)[["ImageNb"]][cur_table$from]
    
    test <- cur_table %>% group_by(from, image, from_label) %>%
        count(as.factor(to_label)) %>% ungroup() %>% 
        group_by(image, from_label, `as.factor(to_label)`) %>% summarize(ct = mean(n))
    
    test <- as.data.frame(test)
    test <- test[order(test$image, test$from_label, test$`as.factor(to_label)`),]
    
    expect_equal(cur_out$ct[!is.na(cur_out$ct)], test$ct)
    
    # As factor
    pancreasSCE$CellType <- as.factor(pancreasSCE$CellType)
    expect_silent(cur_out_2 <- countInteractions(pancreasSCE, group_by = "ImageNb",
                                                     label = "CellType", method = "conditional",
                                                     colPairName = "knn_interaction_graph")) 
    cur_out_2 <- as.data.frame(cur_out_2)
    cur_out_2 <- cur_out_2[order(cur_out_2$group_by, cur_out_2$from_label, cur_out_2$to_label),]
    
    expect_equal(cur_out_2$ct, cur_out$ct)
    
    # As character
    pancreasSCE$CellType <- as.character(pancreasSCE$CellType)
    expect_silent(cur_out_2 <- countInteractions(pancreasSCE, group_by = "ImageNb",
                                                     label = "CellType", method = "conditional",
                                                     colPairName = "knn_interaction_graph")) 
    cur_out_2 <- as.data.frame(cur_out_2)
    cur_out_2 <- cur_out_2[order(cur_out_2$group_by, cur_out_2$from_label, cur_out_2$to_label),]
    
    expect_equal(cur_out_2$ct, cur_out$ct)
    
    # As numeric
    pancreasSCE$CellType <- as.numeric(as.factor(pancreasSCE$CellType))
    expect_silent(cur_out_2 <- countInteractions(pancreasSCE, group_by = "ImageNb",
                                                     label = "CellType", method = "conditional",
                                                     colPairName = "knn_interaction_graph")) 
    cur_out_2 <- as.data.frame(cur_out_2)
    cur_out_2 <- cur_out_2[order(cur_out_2$group_by, cur_out_2$from_label, cur_out_2$to_label),]
    
    expect_equal(cur_out_2$ct, cur_out$ct)
    
    # Logical
    expect_silent(cur_out_2 <- countInteractions(pancreasSCE, group_by = "ImageNb",
                                                   label = "Pattern", method = "conditional",
                                                   colPairName = "knn_interaction_graph")) 
    
    cur_out_2 <- as.data.frame(cur_out_2)
    cur_out_2 <- cur_out_2[order(cur_out_2$group_by, cur_out_2$from_label, cur_out_2$to_label),]
    
    cur_table <- as.data.frame(colPair(pancreasSCE, "knn_interaction_graph"))
    cur_table$from_label <- colData(pancreasSCE)[["Pattern"]][cur_table$from]
    cur_table$to_label <- colData(pancreasSCE)[["Pattern"]][cur_table$to]
    cur_table$image <- colData(pancreasSCE)[["ImageNb"]][cur_table$from]
    
    test <- cur_table %>% group_by(from, image, from_label) %>%
        count(as.factor(to_label)) %>% ungroup() %>% 
        group_by(image, from_label, `as.factor(to_label)`) %>% summarize(ct = mean(n))
    
    expect_equal(cur_out_2$ct, test$ct) 
    
    # One image only contains one cell type
    data(pancreasSCE)
    
    pancreasSCE <- buildSpatialGraph(pancreasSCE, img_id = "ImageNb", type = "knn",
                                     k = 3)
    
    pancreasSCE$test <- pancreasSCE$CellType
    pancreasSCE$test[pancreasSCE$ImageNb == 3] <- "test" 
    expect_silent(cur_out_3 <- countInteractions(pancreasSCE, group_by = "ImageNb",
                                                     label = "test", method = "conditional",
                                                     colPairName = "knn_interaction_graph")) 
    
    cur_out_3 <- as.data.frame(cur_out_3)
    cur_out_3 <- cur_out_3[order(cur_out_3$group_by, cur_out_3$from_label, cur_out_3$to_label),]
    
    cur_table <- as.data.frame(colPair(pancreasSCE, "knn_interaction_graph"))
    cur_table$from_label <- colData(pancreasSCE)[["test"]][cur_table$from]
    cur_table$to_label <- colData(pancreasSCE)[["test"]][cur_table$to]
    cur_table$image <- colData(pancreasSCE)[["ImageNb"]][cur_table$from]
    
    test <- cur_table %>% group_by(from, image, from_label) %>%
        count(as.factor(to_label)) %>% ungroup() %>% 
        group_by(image, from_label, `as.factor(to_label)`) %>% summarize(ct = mean(n))
    
    expect_equal(cur_out_3$ct[!is.na(cur_out_3$ct)], test$ct) 
    expect_equal(cur_out_3$ct[cur_out_3$group_by != 3 & !is.na(cur_out_3$ct)], 
                 cur_out$ct[cur_out$group_by != 3]) 
    
    data(pancreasSCE)
    pancreasSCE <- buildSpatialGraph(pancreasSCE, img_id = "ImageNb", type = "knn",
                                     k = 3)
    pancreasSCE$ImageName <- "test"
    
    expect_silent(cur_out <- countInteractions(pancreasSCE, group_by = "ImageName",
                                                   label = "CellType", method = "conditional",
                                                   colPairName = "knn_interaction_graph")) 
    
    cur_table <- as.data.frame(colPair(pancreasSCE, "knn_interaction_graph"))
    cur_table$from_label <- colData(pancreasSCE)[["CellType"]][cur_table$from]
    cur_table$to_label <- colData(pancreasSCE)[["CellType"]][cur_table$to]
    cur_table$image <- colData(pancreasSCE)[["ImageName"]][cur_table$from]
    
    test <- cur_table %>% group_by(from, image, from_label) %>%
        count(as.factor(to_label)) %>% ungroup() %>% 
        group_by(image, from_label, `as.factor(to_label)`) %>% summarize(ct = mean(n))
    
    expect_equal(cur_out$ct, test$ct)
    
    ########################### patch ############################
    data(pancreasSCE)
    
    pancreasSCE <- buildSpatialGraph(pancreasSCE, img_id = "ImageNb", type = "knn",
                                     k = 3)
    
    expect_silent(cur_out <- countInteractions(pancreasSCE, group_by = "ImageNb",
                                                   label = "CellType", method = "patch",
                                                   patch_size = 3,
                                                   colPairName = "knn_interaction_graph")) 
    
    cur_out <- as.data.frame(cur_out)
    cur_out <- cur_out[order(cur_out$group_by, cur_out$from_label, cur_out$to_label),]
    
    cur_table <- as.data.frame(colPair(pancreasSCE, "knn_interaction_graph"))
    cur_table$from_label <- colData(pancreasSCE)[["CellType"]][cur_table$from]
    cur_table$to_label <- colData(pancreasSCE)[["CellType"]][cur_table$to]
    cur_table$image <- colData(pancreasSCE)[["ImageNb"]][cur_table$from]
    
    test <- cur_table %>% group_by(from, image, from_label) %>%
        count(as.factor(to_label), .drop = FALSE) %>% ungroup() %>% 
        mutate(ct = n >= 3) %>%
        group_by(image, from_label, `as.factor(to_label)`) %>% summarize(ct = mean(ct))
    
    test <- as.data.frame(test)
    test <- test[order(test$image, test$from_label, test$`as.factor(to_label)`),]
    
    cur_out_2 <- cur_out
    cur_out_2 <- cur_out_2[match(paste(test$image, test$from_label, test$`as.factor(to_label)`),
                                 paste(cur_out_2$group_by, cur_out_2$from_label, cur_out_2$to_label)),]
    
    expect_equal(cur_out_2$ct[!is.na(cur_out_2$ct)], test$ct[!is.na(cur_out_2$ct)])
    
    # As factor
    pancreasSCE$CellType <- as.factor(pancreasSCE$CellType)
    expect_silent(cur_out_2 <- countInteractions(pancreasSCE, group_by = "ImageNb",
                                                     label = "CellType", method = "patch",
                                                     patch_size = 3,
                                                     colPairName = "knn_interaction_graph")) 
    cur_out_2 <- as.data.frame(cur_out_2)
    cur_out_2 <- cur_out_2[order(cur_out_2$group_by, cur_out_2$from_label, cur_out_2$to_label),]
    
    expect_equal(cur_out_2$ct, cur_out$ct)
    
    # As character
    pancreasSCE$CellType <- as.character(pancreasSCE$CellType)
    expect_silent(cur_out_2 <- countInteractions(pancreasSCE, group_by = "ImageNb",
                                                     label = "CellType", method = "patch",
                                                     patch_size = 3,
                                                     colPairName = "knn_interaction_graph")) 
    cur_out_2 <- as.data.frame(cur_out_2)
    cur_out_2 <- cur_out_2[order(cur_out_2$group_by, cur_out_2$from_label, cur_out_2$to_label),]
    
    expect_equal(cur_out_2$ct, cur_out$ct)
    
    # As numeric
    pancreasSCE$CellType <- as.numeric(as.factor(pancreasSCE$CellType))
    expect_silent(cur_out_2 <- countInteractions(pancreasSCE, group_by = "ImageNb",
                                                     label = "CellType", method = "patch",
                                                     patch_size = 3,
                                                     colPairName = "knn_interaction_graph")) 
    cur_out_2 <- as.data.frame(cur_out_2)
    cur_out_2 <- cur_out_2[order(cur_out_2$group_by, cur_out_2$from_label, cur_out_2$to_label),]
    
    expect_equal(cur_out_2$ct, cur_out$ct)
    
    # Logical
    expect_silent(cur_out_2 <- countInteractions(pancreasSCE, group_by = "ImageNb",
                                                     label = "Pattern", method = "patch",
                                                     patch_size = 3,
                                                     colPairName = "knn_interaction_graph")) 
    
    cur_out_2 <- as.data.frame(cur_out_2)
    cur_out_2 <- cur_out_2[order(cur_out_2$group_by, cur_out_2$from_label, cur_out_2$to_label),]
    
    cur_table <- as.data.frame(colPair(pancreasSCE, "knn_interaction_graph"))
    cur_table$from_label <- colData(pancreasSCE)[["Pattern"]][cur_table$from]
    cur_table$to_label <- colData(pancreasSCE)[["Pattern"]][cur_table$to]
    cur_table$image <- colData(pancreasSCE)[["ImageNb"]][cur_table$from]
    
    test <- cur_table %>% group_by(from, image, from_label) %>%
        count(as.factor(to_label), .drop = FALSE) %>%
        mutate(ct = n >= 3) %>% ungroup() %>% 
        group_by(image, from_label, `as.factor(to_label)`) %>% summarize(ct = mean(ct))
    
    expect_equal(cur_out_2$ct[!is.na(cur_out_2$ct)], test$ct[!is.na(cur_out_2$ct)]) 
    
    # One image only contains one cell type
    data(pancreasSCE)
    
    pancreasSCE <- buildSpatialGraph(pancreasSCE, img_id = "ImageNb", type = "knn",
                                     k = 3)
    
    pancreasSCE$test <- pancreasSCE$CellType
    pancreasSCE$test[pancreasSCE$ImageNb == 3] <- "test" 
    expect_silent(cur_out_3 <- countInteractions(pancreasSCE, group_by = "ImageNb",
                                                     label = "test", method = "patch",
                                                     patch_size = 3,
                                                     colPairName = "knn_interaction_graph")) 
    
    cur_out_3 <- as.data.frame(cur_out_3)
    cur_out_3 <- cur_out_3[order(cur_out_3$group_by, cur_out_3$from_label, cur_out_3$to_label),]
    
    cur_table <- as.data.frame(colPair(pancreasSCE, "knn_interaction_graph"))
    cur_table$from_label <- colData(pancreasSCE)[["test"]][cur_table$from]
    cur_table$to_label <- colData(pancreasSCE)[["test"]][cur_table$to]
    cur_table$image <- colData(pancreasSCE)[["ImageNb"]][cur_table$from]
    
    test <- cur_table %>% group_by(from, image, from_label) %>%
        count(as.factor(to_label), .drop = FALSE) %>% 
        mutate(ct = n >= 3) %>% ungroup() %>% 
        group_by(image, from_label, `as.factor(to_label)`) %>% summarize(ct = mean(ct))
    
    cur_out_4 <- cur_out_3
    cur_out_4 <- cur_out_4[match(paste(test$image, test$from_label, test$`as.factor(to_label)`),
                                 paste(cur_out_4$group_by, cur_out_4$from_label, cur_out_4$to_label)),]
    
    expect_equal(cur_out_4$ct[!is.na(cur_out_4$ct)], test$ct[!is.na(cur_out_4$ct)]) 
    expect_equal(cur_out_3$ct[!is.na(cur_out_3$ct) & cur_out_3$group_by != 3], cur_out$ct[!is.na(cur_out$ct) & cur_out$group_by != 3]) 
    
    data(pancreasSCE)
    
    pancreasSCE <- buildSpatialGraph(pancreasSCE, img_id = "ImageNb", type = "knn",
                                     k = 3)
    
    expect_silent(cur_out <- countInteractions(pancreasSCE, group_by = "ImageNb",
                                                   label = "CellType", method = "patch",
                                                   patch_size = 4,
                                                   colPairName = "knn_interaction_graph")) 
    
    expect_equal(cur_out$ct[!is.na(cur_out$ct)], rep(0, 22))
    
    expect_silent(cur_out <- countInteractions(pancreasSCE, group_by = "ImageNb",
                                                   label = "CellType", method = "patch",
                                                   patch_size = 0,
                                                   colPairName = "knn_interaction_graph")) 
    
    expect_equal(cur_out$ct[!is.na(cur_out$ct)], rep(1, 22))
    
    expect_silent(cur_out <- countInteractions(pancreasSCE, group_by = "ImageNb",
                                                   label = "CellType", method = "patch",
                                                   patch_size = 1,
                                                   colPairName = "knn_interaction_graph")) 
    
    cur_table <- as.data.frame(colPair(pancreasSCE, "knn_interaction_graph"))
    cur_table$from_label <- colData(pancreasSCE)[["CellType"]][cur_table$from]
    cur_table$to_label <- colData(pancreasSCE)[["CellType"]][cur_table$to]
    cur_table$image <- colData(pancreasSCE)[["ImageNb"]][cur_table$from]
    
    test <- cur_table %>% group_by(from, image, from_label) %>%
        count(as.factor(to_label), .drop = FALSE) %>% 
        mutate(ct = n >= 1) %>% ungroup() %>% 
        group_by(image, from_label, `as.factor(to_label)`) %>% summarize(ct = mean(ct))
    
    cur_out_2 <- cur_out
    cur_out_2 <- cur_out_2[match(paste(test$image, test$from_label, test$`as.factor(to_label)`),
                                 paste(cur_out_2$group_by, cur_out_2$from_label, cur_out_2$to_label)),]
    
    expect_equal(cur_out_2$ct[!is.na(cur_out_2$ct)], test$ct[!is.na(cur_out_2$ct)]) 
    
    data(pancreasSCE)
    pancreasSCE <- buildSpatialGraph(pancreasSCE, img_id = "ImageNb", type = "knn",
                                     k = 3)
    pancreasSCE$ImageName <- "test"
    
    expect_silent(cur_out <- countInteractions(pancreasSCE, group_by = "ImageName",
                                                   label = "CellType", method = "patch",
                                                   patch_size = 3,
                                                   colPairName = "knn_interaction_graph")) 
    
    cur_table <- as.data.frame(colPair(pancreasSCE, "knn_interaction_graph"))
    cur_table$from_label <- colData(pancreasSCE)[["CellType"]][cur_table$from]
    cur_table$to_label <- colData(pancreasSCE)[["CellType"]][cur_table$to]
    cur_table$image <- colData(pancreasSCE)[["ImageName"]][cur_table$from]
    
    test <- cur_table %>% group_by(from, image, from_label) %>%
        count(as.factor(to_label), .drop = FALSE) %>% 
        mutate(ct = n >= 3) %>% ungroup() %>% 
        group_by(image, from_label, `as.factor(to_label)`) %>% summarize(ct = mean(ct))
    
    expect_equal(cur_out$ct, test$ct)
    
    data(pancreasSCE)
    pancreasSCE <- buildSpatialGraph(pancreasSCE, img_id = "ImageNb", type = "knn",
                                     k = 3)
    
    ############################ interaction ############################
    
    data(pancreasSCE)
    
    pancreasSCE <- buildSpatialGraph(pancreasSCE, img_id = "ImageNb", type = "knn",
                                     k = 3)
    
    expect_silent(cur_out <- countInteractions(pancreasSCE, group_by = "ImageNb",
                                               label = "CellType", method = "interaction",
                                               colPairName = "knn_interaction_graph")) 
    cur_out <- as.data.frame(cur_out)
    cur_out <- cur_out[order(cur_out$group_by, cur_out$from_label, cur_out$to_label),]
    
    # Check against manual calculations
    cur_table <- as.data.frame(colPair(pancreasSCE, "knn_interaction_graph"))
    cur_table$from_label <- colData(pancreasSCE)[["CellType"]][cur_table$from]
    cur_table$to_label <- colData(pancreasSCE)[["CellType"]][cur_table$to]
    cur_table$image <- colData(pancreasSCE)[["ImageNb"]][cur_table$from]
    
    test <- cur_table %>% group_by(image, from_label, to_label) %>%
      summarize(N = n(), .groups = "drop") %>%
      group_by(image, from_label) %>% mutate(n_tot_int = sum(N)) %>%
      ungroup() %>% mutate(ct = N / n_tot_int)
    
    test <- as.data.frame(test)
    test <- test[order(test$image, test$from_label, test$to_label),]
    
    cur_out_2 <- cur_out
    cur_out_2 <- cur_out_2[match(paste(test$image, test$from_label, test$to_label),
                                 paste(cur_out_2$group_by, cur_out_2$from_label, cur_out_2$to_label)),]
    
    expect_equal(cur_out_2$ct[!is.na(cur_out_2$ct)], test$ct[!is.na(cur_out_2$ct)]) 
    
    # As factor
    pancreasSCE$CellType <- as.factor(pancreasSCE$CellType)
    expect_silent(cur_out_2 <- countInteractions(pancreasSCE, group_by = "ImageNb",
                                                 label = "CellType", method = "interaction",
                                                 colPairName = "knn_interaction_graph")) 
    cur_out_2 <- as.data.frame(cur_out_2)
    cur_out_2 <- cur_out_2[order(cur_out_2$group_by, cur_out_2$from_label, cur_out_2$to_label),]
    
    expect_equal(cur_out_2$ct, cur_out$ct)
    
    # As character
    pancreasSCE$CellType <- as.character(pancreasSCE$CellType)
    expect_silent(cur_out_2 <- countInteractions(pancreasSCE, group_by = "ImageNb",
                                                 label = "CellType", method = "interaction",
                                                 colPairName = "knn_interaction_graph")) 
    cur_out_2 <- as.data.frame(cur_out_2)
    cur_out_2 <- cur_out_2[order(cur_out_2$group_by, cur_out_2$from_label, cur_out_2$to_label),]
    
    expect_equal(cur_out_2, cur_out)
    
    # As numeric
    pancreasSCE$CellType <- as.numeric(as.factor(pancreasSCE$CellType))
    expect_silent(cur_out_2 <- countInteractions(pancreasSCE, group_by = "ImageNb",
                                                 label = "CellType", method = "interaction",
                                                 colPairName = "knn_interaction_graph")) 
    cur_out_2 <- as.data.frame(cur_out_2)
    cur_out_2 <- cur_out_2[order(cur_out_2$group_by, cur_out_2$from_label, cur_out_2$to_label),]
    
    expect_equal(cur_out_2$ct, cur_out$ct)
    
    # Logical
    expect_silent(cur_out_2 <- countInteractions(pancreasSCE, group_by = "ImageNb",
                                                 label = "Pattern", method = "interaction",
                                                 colPairName = "knn_interaction_graph")) 
    
    cur_out_2 <- as.data.frame(cur_out_2)
    cur_out_2 <- cur_out_2[order(cur_out_2$group_by, cur_out_2$from_label, cur_out_2$to_label),]
    
    cur_table <- as.data.frame(colPair(pancreasSCE, "knn_interaction_graph"))
    cur_table$from_label <- colData(pancreasSCE)[["Pattern"]][cur_table$from]
    cur_table$to_label <- colData(pancreasSCE)[["Pattern"]][cur_table$to]
    cur_table$image <- colData(pancreasSCE)[["ImageNb"]][cur_table$from]
    
    test <- cur_table %>% group_by(image, from_label, to_label) %>%
      summarize(N = n(), .groups = "drop") %>%
      group_by(image, from_label) %>% mutate(n_tot_int = sum(N)) %>%
      ungroup() %>% mutate(ct = N / n_tot_int)
    
    expect_equal(cur_out_2$ct[!is.na(cur_out_2$ct)], test$ct[!is.na(cur_out_2$ct)])
    
    # ct values sum up to 1 for the "from_label" cell-type per grouping level
    expect_silent(cur_out <- countInteractions(pancreasSCE, group_by = "ImageNb",
                                               label = "CellType", method = "interaction",
                                               colPairName = "knn_interaction_graph")) 
    
    test <- cur_out %>% as.data.frame() %>% filter(!is.na(ct)) %>% group_by(group_by, from_label) %>% summarise(sum_ct = sum(ct))
    
    expect_equal(sum(test$sum_ct)/nrow(test), 1)
    
    # One image only contains one cell type
    data(pancreasSCE)
    
    pancreasSCE <- buildSpatialGraph(pancreasSCE, img_id = "ImageNb", type = "knn",
                                     k = 3)
    
    pancreasSCE$test <- pancreasSCE$CellType
    pancreasSCE$test[pancreasSCE$ImageNb == 3] <- "test" 
    expect_silent(cur_out_3 <- countInteractions(pancreasSCE, group_by = "ImageNb",
                                                 label = "test", method = "interaction",
                                                 colPairName = "knn_interaction_graph")) 
    
    cur_out_3 <- as.data.frame(cur_out_3)
    cur_out_3 <- cur_out_3[order(cur_out_3$group_by, cur_out_3$from_label, cur_out_3$to_label),]
    
    cur_table <- as.data.frame(colPair(pancreasSCE, "knn_interaction_graph"))
    cur_table$from_label <- colData(pancreasSCE)[["test"]][cur_table$from]
    cur_table$to_label <- colData(pancreasSCE)[["test"]][cur_table$to]
    cur_table$image <- colData(pancreasSCE)[["ImageNb"]][cur_table$from]
    
    test <- cur_table %>% group_by(image, from_label, to_label) %>%
      summarize(N = n(), .groups = "drop") %>%
      group_by(image, from_label) %>% mutate(n_tot_int = sum(N)) %>%
      ungroup() %>% mutate(ct = N / n_tot_int)
    
    cur_out_4 <- cur_out_3
    cur_out_4 <- cur_out_4[match(paste(test$image, test$from_label, test$to_label),
                                 paste(cur_out_4$group_by, cur_out_4$from_label, cur_out_4$to_label)),]
    
    expect_equal(cur_out_4$ct[!is.na(cur_out_4$ct)], test$ct[!is.na(cur_out_4$ct)]) 
    expect_equal(cur_out_3$ct[!is.na(cur_out_3$ct) & cur_out_3$group_by != 3], cur_out$ct[!is.na(cur_out$ct) & cur_out$group_by != 3]) 
    
    data(pancreasSCE)
    pancreasSCE <- buildSpatialGraph(pancreasSCE, img_id = "ImageNb", type = "knn",
                                     k = 3)
    pancreasSCE$ImageName <- "test"
    
    expect_silent(cur_out <- countInteractions(pancreasSCE, group_by = "ImageName",
                                               label = "CellType", method = "interaction",
                                               colPairName = "knn_interaction_graph")) 
    
    cur_table <- as.data.frame(colPair(pancreasSCE, "knn_interaction_graph"))
    cur_table$from_label <- colData(pancreasSCE)[["CellType"]][cur_table$from]
    cur_table$to_label <- colData(pancreasSCE)[["CellType"]][cur_table$to]
    cur_table$image <- colData(pancreasSCE)[["ImageName"]][cur_table$from]
    
    test <- cur_table %>% group_by(image, from_label, to_label) %>%
      summarize(N = n(), .groups = "drop") %>%
      group_by(image, from_label) %>% mutate(n_tot_int = sum(N)) %>%
      ungroup() %>% mutate(ct = N / n_tot_int)
    
    expect_equal(cur_out$ct, test$ct)
    
    # Fail
    expect_error(countInteractions("test"),
                 regexp = "'object' not of type 'SingleCellExperiment'.",
                 fixed = TRUE)
    expect_error(countInteractions(pancreasSCE, group_by = "test_test", label = "CellType", colPairName = "knn_interaction_graph"),
                 regexp = "'group_by' not in colData(object).",
                 fixed = TRUE)
    expect_error(countInteractions(pancreasSCE, group_by = 1, label = "CellType", colPairName = "knn_interaction_graph"),
                 regexp = "'group_by' must be a single string.",
                 fixed = TRUE)
    expect_error(countInteractions(pancreasSCE, group_by = "ImageNb", label = "test_test", colPairName = "knn_interaction_graph"),
                 regexp = "'label' not in colData(object).",
                 fixed = TRUE)
    expect_error(countInteractions(pancreasSCE, group_by = "ImageNb", label = 1, colPairName = "knn_interaction_graph"),
                 regexp = "'label' must be a single string.",
                 fixed = TRUE)
    expect_error(countInteractions(pancreasSCE, group_by = "ImageNb", label = "CellType", colPairName = "test"),
                 regexp = "'colPairName' not in colPairNames(object).",
                 fixed = TRUE)
    expect_error(countInteractions(pancreasSCE, group_by = "ImageNb", label = "CellType", colPairName = 1),
                 regexp = "'colPairName' must be a single string.",
                 fixed = TRUE)
    expect_error(countInteractions(pancreasSCE, group_by = "ImageNb", label = "CellType", colPairName = "knn_interaction_graph",
                                       method = "patch"),
                 regexp = "When method = 'patch', please specify 'patch_size'.",
                 fixed = TRUE)
    expect_error(countInteractions(pancreasSCE, group_by = "ImageNb", label = "CellType", colPairName = "knn_interaction_graph",
                                       method = "patch", patch_size = "test"),
                 regexp = "'patch_size' must be a single numeric.",
                 fixed = TRUE)
})
