% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateFrequency.R
\name{calculateFrequency}
\alias{calculateFrequency}
\title{Relative Residue Frequencies at Every Position}
\usage{
calculateFrequency(
  input.sequences,
  max.length = NULL,
  sequence.dictionary = amino.acids,
  padding.symbol = ".",
  summary.fun = c("proportion", "count", "percent"),
  tidy = FALSE
)
}
\arguments{
\item{input.sequences}{Character vector of sequences (amino acid or 
nucleotide)}

\item{max.length}{Integer.  Pad/trim to this length. Defaults to
`max(nchar(sequences))`.}

\item{sequence.dictionary}{Vector of valid residue symbols that should be
tracked (defaults to the 20 canonical amino acids; supply
`c("A","C","G","T","N")` etc. for nucleotides).}

\item{padding.symbol}{Single character used for right-padding. **Must not**
be present in `sequence.dictionary`.}

\item{summary.fun}{Character string choosing the summary statistic:
* `"proportion"` (default) – each cell sums to 1 over the table.  
* `"count"`      – raw counts.  
* `"percent"`    – proportion × 100.}

\item{tidy}{Logical; if `TRUE` a long-format `data.frame` is returned
instead of a matrix (useful for plotting with *ggplot2*).}
}
\value{
Either
\itemize{
  \item A numeric matrix of dimension `length(sequence.dictionary)` ×
        `max.length`, whose columns sum to 1, **or**
  \item A `data.frame` with columns *position*, *residue*, *frequency* when
        `tidy = TRUE`.
}
}
\description{
Quickly computes the per-position relative frequency of each symbol
(amino-acid or nucleotide) in a set of biological sequences.  Variable-length
strings are padded to a common width so the calculation is entirely
vectorized (one logical comparison + one `colSums()` per residue).
}
\examples{
# Amino Acid example
seqs <- c("CASSLGQGAETQYF", "CASSPGQGDYEQYF", "CASSQETQYF")
rel.freq <- calculateFrequency(seqs)
head(rel.freq[, 1:5])                  

# Nucleotide example
dna <- c("ATGCC", "ATGAC", "ATGGC")
calculateFrequency(dna,
                   sequence.dictionary = c("A","C","G","T"),
                   padding.symbol = "-",
                   tidy = TRUE)

}
