% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatGenes.R
\name{formatGenes}
\alias{formatGenes}
\title{Ensure clean gene nomenclature using IMGT annotations}
\usage{
formatGenes(
  input.data,
  region = "v",
  technology = NULL,
  species = "human",
  simplify.format = TRUE
)
}
\arguments{
\item{input.data}{Data frame of sequencing data or scRepertoire outputs}

\item{region}{Sequence gene loci to access - "v", "d", "j", or "c"
or a combination using c("v", "d", "j")}

\item{technology}{The sequencing technology employed - \strong{'TenX'}, \strong{"Adaptive'}, or
\strong{'AIRR'}}

\item{species}{One or two word designation of species. Currently supporting: 
"human", "mouse", "rat", "rabbit", "rhesus monkey", "sheep", "pig", "platypus",
"alpaca", "dog", "chicken", and "ferret"}

\item{simplify.format}{If applicable, remove the allelic designation (\strong{TRUE}) or
retain all information (\strong{FALSE})}
}
\value{
A data frame with the new columns of formatted genes added.
}
\description{
This function will format the genes into a clean
nomenclature using the IMGT conventions.
}
\examples{
data(immapex_example.data)
formatGenes(immapex_example.data[["TenX"]],
            region = "v",
            technology = "TenX")

}
