% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inferCNV_BayesNet.R
\docType{class}
\name{MCMC_inferCNV-class}
\alias{MCMC_inferCNV-class}
\alias{MCMC_inferCNV}
\title{MCMC_inferCNV class}
\description{
Uses Markov Chain Monte Carlo (MCMC) and Gibbs sampling to estimate the posterior
probability of being in one of six Copy Number Variation states (states: 0, 0.5, 1, 1.5, 2, 3) for CNV's identified by
inferCNV's HMM. Posterior probabilities are found for the entire CNV cluster and each individual
cell line in the CNV.
}
\section{Slots}{

\describe{
\item{\code{bugs_model}}{BUGS model.}

\item{\code{sig}}{fitted values for cell lines, 1/standard deviation to be used for determining the distribution of each cell line}

\item{\code{mu}}{Mean values to be used for determining the distribution of each cell line}

\item{\code{group_id}}{ID's given to the cell clusters.}

\item{\code{cell_gene}}{List containing the Cells and Genes that make up each CNV.}

\item{\code{cnv_probabilities}}{Probabilities of each CNV belonging to a particular state from 0 (least likely)to 1 (most likely).}

\item{\code{cell_probabilities}}{Probabilities of each cell being in a particular state, from 0 (least likely)to 1 (most likely).}

\item{\code{args}}{Input arguments given by the user}

\item{\code{cnv_regions}}{ID for each CNV found by the HMM}
}}

\keyword{classes}
