% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllMethods.R
\docType{methods}
\name{isoSelect}
\alias{isoSelect}
\alias{isoSelect.IsomirDataSeq}
\alias{isoSelect,IsomirDataSeq-method}
\title{Method to select specific miRNAs from an IsomirDataSeq object.}
\usage{
isoSelect.IsomirDataSeq(object, mirna, minc = 10)

\S4method{isoSelect}{IsomirDataSeq}(object, mirna, minc = 10)
}
\arguments{
\item{object}{A \link{IsomirDataSeq} object.}

\item{mirna}{String referring to the miRNA to show.}

\item{minc}{Minimum number of isomiR reads needed
to be included in the table.}
}
\value{
\link[S4Vectors:DataFrame-class]{S4Vectors::DataFrame} with count
information. The \code{row.names}
show the isomiR names, and each of the columns shows the counts
for this isomiR in that sample. Mainly, it will return the count
matrix only for isomiRs belonging to the miRNA family given by
the \code{mirna} parameter. IsomiRs need to have counts bigger than
\code{minc} parameter at least in one sample to be included in the output.
Annotation of isomiRs follows these rules:
\itemize{
\item miRNA name
\item mismatches
\item additions
\item 5 trimming events
\item 3 trimming events
}
}
\description{
This method allows to select a miRNA and all its isomiRs
from the count matrix.
}
\examples{
data(mirData)
# To select isomiRs from let-7a-5p miRNA
# and with 10000 reads or more.
isoSelect(mirData, mirna="hsa-let-7a-5p", minc=10000)
}
\author{
Lorena Pantano
}
