% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/symmetricPair.R
\name{symmetricPairKernel}
\alias{symmetricPairKernel}
\title{Symmetric Pair Kernel}
\usage{
symmetricPairKernel(siKernel, kernelType = c("mean", "TPPK"), r = 1)
}
\arguments{
\item{siKernel}{kernel for single instances}

\item{kernelType}{defines the type of pair kernel. It specifies in which
way the similarity between two pairs of sequences are computed. Allowed
values are "mean", and "TPPK" (see also details section). Default="mean"}

\item{r}{exponent which must be > 0 (details see below). Default=1}
}
\value{
symmetricPairKernel: upon successful completion, the function returns a
kernel object of class \code{\linkS4class{SymmetricPairKernel}}.
}
\description{
Create a symmetric pair kernel object
}
\details{
Creation of kernel object\cr\cr
The function 'symmetricPairKernel' creates a kernel object for the symmetric
pair kernel. This kernel is an example for multiple instance learning and
can be used for learning based on pairs of sequences. The single instance
kernel passed to the symmetric pair kernel computes a similarity between
two individual sequences giving a similarity for one pair of sequences.
The symmetric pair kernel function gets as input two pairs of sequences and
computes a similarity value between the two pairs. This similarity is
computed dependent on the value of the argument \code{kernelType} from the
similarities delivered by the single instance kernel in the following
way:\cr\cr

\code{mean} (arithmetic mean):\cr\cr
k(<a,b>, <c,d>) = 1/4 * (k(a,c) + k(a,d) + k(b,c) + k(b,d))

\code{TPKK} (tensor pairwise product kernel):\cr\cr
k(<a,b>, <c,d>) = (k(a,c) * k(b,d) + k(a,d) * k(b,c))

Every sequence kernel available in KeBABS can be used as single instance
kernel for the symmetric pair kernel allowing to create similarity
measures between two pairs of sequences based on different similarity
measures between individual sequences.

The row names and column names of a kernel matrix generated from a symmetric
pair kernel object describe the sequence pair with the names of the
individual sequences in the pair separated by the underscore character.

For values different from 1 (=default value) parameter \code{r}
leads to a transfomation of similarities by taking each element of the
similarity matrix to the power of r. Only integer values larger than 1
should be used for r in context with SVMs requiring positive definite
kernels.

The symmetricPairKernel can be used in sequence based learning like any
single instance kernel. Label values are defined against pairs of sequences
in this case. Explicit representation, feature weights and prediction
profiles are not available for the symmetric pair kernel. As kernels
computed through sums and products of postive definite kernels all variants
of this kernel are positive definite.
}
\examples{
## load sample sequences from transcription factor binding dataset
data(TFBS)
## in this example we just use the first 30 sequences and rename samples
x <- enhancerFB[1:30]
names(x) <- paste("S", 1:length(x), sep="")

## create the single instance kernel object
specK5 <- spectrumKernel(k=5)
## show details of single instance kernel object
specK5

## create the symmetric pair kernel object for the single instance kernel
tppk <- symmetricPairKernel(siKernel=specK5, kernelType="TPPK")

## generate the kernel matrix with the symmetric pair kernel object which
## contains similarity values between two pairs of sequences.
## Hint: The kernel matrix for the single instance kernel is computed
## internally.
km <- tppk(x)
dim(km)
km[1:5,1:5]

\dontrun{
## plot heatmap of the kernel matrix
heatmap(km, symm=TRUE)
}
}
\author{
Johannes Palme
}
\references{
\url{https://github.com/UBod/kebabs}\cr\cr
M. Hue and J.-P.Vert (2010) On learning with kernels for unordered
pairs. \emph{Proc. 27th Int. Conf. on Machine Learning}, pp. 463-470.\cr\cr
A. Ben-Hur and W.S. Noble (2005) Kernel methods for predicting
protein-protein interactions. \cr\cr
T. Gaertner, P.A. Flach, A. Kowalczyk, and A.J. Smola (2002)
Multi-instance kernels. \emph{Proc. 19th Int. Conf. on Machine Learning},
pp. 179-186.\cr\cr
J. Palme, S. Hochreiter, and U. Bodenhofer (2015) KeBABS: an R package
for kernel-based analysis of biological sequences.
\emph{Bioinformatics}, 31(15):2574-2576.
DOI: \doi{10.1093/bioinformatics/btv176}.
}
\seealso{
\code{\link{kernelParameters-method}},
\code{\link{getKernelMatrix}}, \code{\link{spectrumKernel}},
\code{\link{mismatchKernel}}, \code{\link{motifKernel}},
\code{\link{gappyPairKernel}}, \code{\linkS4class{SymmetricPairKernel}}
}
\keyword{instance}
\keyword{kernel}
\keyword{learning}
\keyword{methods}
\keyword{multiple}
\keyword{pair}
\keyword{symmetric}
\keyword{symmetricPairKernel}

