% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testEnrichment.R
\name{buildGeneDBs}
\alias{buildGeneDBs}
\title{build gene-probe association database}
\usage{
buildGeneDBs(
  probeIDs = NULL,
  platform = NULL,
  genome = NULL,
  max_distance = 10000,
  silent = FALSE
)
}
\arguments{
\item{probeIDs}{the query probe list. If NULL, use all the probes
on the platform}

\item{platform}{HM450, EPIC, MM285, Mammal40, will infer from
query if not given}

\item{genome}{hg38, mm10, ..., will infer if not given.}

\item{max_distance}{probe-gene distance for association}

\item{silent}{suppress messages}
}
\value{
gene databases
}
\description{
build gene-probe association database
}
\examples{
sesameData::sesameDataCache(data_titles=
c("EPIC.address","genomeInfo.hg38","probeIDSignature"))
query <- c("cg04707299", "cg13380562", "cg00480749")
dbs <- buildGeneDBs(query, platform = "EPIC")
testEnrichment(query, dbs, platform = "EPIC")
}
