% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmpLoading1dPlot.R
\name{lmpLoading1dPlot}
\alias{lmpLoading1dPlot}
\title{Loadings represented on a line plot.}
\usage{
lmpLoading1dPlot(resLmpPcaEffects, effectNames = NULL, axes = c(1, 2), ...)
}
\arguments{
\item{resLmpPcaEffects}{A list corresponding to the output value of \code{\link{lmpPcaEffects}}.}

\item{effectNames}{Names of the effects to be plotted. if \code{NULL}, all the effects are plotted.}

\item{axes}{A numerical vector with the Principal Components axes to be drawn.}

\item{...}{Additional arguments to be passed to \code{\link{plotLine}} such as \code{xaxis_type}, \code{type} or \code{ang_x_axis}.}
}
\value{
A list of \code{ggplot} objects representing the loading plots.
}
\description{
Plots the loading vectors for each effect matrix from the \code{\link{lmpPcaEffects}} outputs with line plots. This is a wrapper of plotLine.
}
\details{
\code{lmpLoading1dPlot} is a wrapper of \code{\link{plotLine}}. See \code{?plotLine} for more information on the additional arguments.
}
\examples{

# Example of "spectral" type loadings (line and numerical x-axis)
data("UCH")
resLmpModelMatrix <- lmpModelMatrix(UCH)
resLmpEffectMatrices <- lmpEffectMatrices(resLmpModelMatrix)
resASCA <- lmpPcaEffects(resLmpEffectMatrices,
  combineEffects = list(c("Time", "Hippurate:Time"))
)
lmpLoading1dPlot(resASCA)
lmpLoading1dPlot(resASCA, effectNames = c("Hippurate", "Citrate"))

# Example of "segment" and discrete type loadings (segments and character x-axis)
data("trout")
resLmpModelMatrix <- lmpModelMatrix(trout)
resLmpEffectMatrices <- lmpEffectMatrices(resLmpModelMatrix)
resASCA <- lmpPcaEffects(resLmpEffectMatrices)
lmpLoading1dPlot(resASCA,
  effectNames = "Day",
  xaxis_type = "character", type = "s", ang_x_axis = 90
)
}
