% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/count.R
\name{countInteractibility}
\alias{countInteractibility}
\alias{countInteractibility,linkSet-method}
\title{Count bait and oe interactibility}
\usage{
countInteractibility(x, baitRegions = TRUE)

\S4method{countInteractibility}{linkSet}(x, baitRegions = TRUE)
}
\arguments{
\item{x}{A linkSet object}

\item{baitRegions}{Whether to count bait regions (default: TRUE)}
}
\value{
A linkSet object with counts for each unique interaction
}
\description{
This function calculates the number of trans interactions for each bait and oe.
The word "interactibility" can refer to https://doi.org/10.1038\%2Fnature11279.
}
\details{
Count Interaction Interactibility
}
\examples{
data(linkExample)
linkSet = c(linkExample,linkExample)
linkSet = countInteractions(linkSet)
linkSet = countInteractibility(linkSet)
}
