% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filterMaf.R
\name{filterMaf}
\alias{filterMaf}
\title{Filter MAF objects}
\usage{
filterMaf(maf, genes = NULL, tsb = NULL, isTCGA = FALSE)
}
\arguments{
\item{maf}{an MAF object generated by \code{\link{read.maf}}}

\item{genes}{remove these genes}

\item{tsb}{remove these samples (Tumor Sample Barcodes)}

\item{isTCGA}{FALSE}
}
\value{
Filtered object of class \code{\link{MAF-class}}
}
\description{
Filter MAF by genes or samples
}
\examples{
laml.maf <- system.file("extdata", "tcga_laml.maf.gz", package = "maftools")
laml <- read.maf(maf = laml.maf)
#get rid of samples of interest
filterMaf(maf = laml, tsb = c("TCGA-AB-2830", "TCGA-AB-2804"))
#remove genes of intrest
filterMaf(maf = laml, genes =c("TTN", "AHNAK2"))
}
\seealso{
\code{\link{subsetMaf}}
}
