% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mafGeneSummary.R
\name{mafSummary}
\alias{mafSummary}
\title{Summary statistics of MAF}
\usage{
mafSummary(maf)
}
\arguments{
\item{maf}{an MAF object generated by \code{\link{read.maf}}}
}
\value{
Returns a list of summarized tables
}
\description{
Summarizes genes and samples irrespective of the type of alteration. This is different from \code{\link{getSampleSummary}} and \code{\link{getGeneSummary}} which returns summaries of only non-synonymous variants.
}
\details{
This function takes MAF object as input and returns summary table.
}
\examples{
laml.maf <- system.file("extdata", "tcga_laml.maf.gz", package = "maftools")
laml <- read.maf(maf = laml.maf)
mafSummary(maf = laml)

}
\seealso{
\code{\link{getGeneSummary}} \code{\link{getSampleSummary}}
}
