% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/methods-calcLoopEnrichment.R
\name{calcLoopEnrichment}
\alias{calcLoopEnrichment}
\alias{calcLoopEnrichment,GInteractions,character-method}
\alias{calcLoopEnrichment,InteractionArray,missing-method}
\title{Calculate loop enrichment over background.}
\usage{
calcLoopEnrichment(
  x,
  files,
  fg = selectCenterPixel(mhDist = 1, buffer = defaultBuffer()),
  bg = selectTopLeft(n = 4, buffer = defaultBuffer()) + selectBottomRight(n = 4, buffer =
    defaultBuffer()),
  FUN = function(fg, bg) median(fg + 1)/median(bg + 1),
  nBlocks = 5,
  verbose = TRUE,
  BPPARAM = bpparam(),
  ...
)

\S4method{calcLoopEnrichment}{GInteractions,character}(
  x,
  files,
  fg = selectCenterPixel(mhDist = 1, buffer = defaultBuffer()),
  bg = selectTopLeft(n = 4, buffer = defaultBuffer()) + selectBottomRight(n = 4, buffer =
    defaultBuffer()),
  FUN = function(fg, bg) median(fg + 1)/median(bg + 1),
  nBlocks = 5,
  verbose = TRUE,
  BPPARAM = bpparam(),
  ...
)

\S4method{calcLoopEnrichment}{InteractionArray,missing}(
  x,
  files,
  fg = selectCenterPixel(mhDist = 1, buffer = defaultBuffer()),
  bg = selectTopLeft(n = 4, buffer = defaultBuffer()) + selectBottomRight(n = 4, buffer =
    defaultBuffer()),
  FUN = function(fg, bg) median(fg + 1)/median(bg + 1),
  nBlocks = 5,
  verbose = TRUE,
  BPPARAM = bpparam(),
  ...
)
}
\arguments{
\item{x}{GInteractions object or an InteractionArray object.}

\item{files}{Character file paths to `.hic` files. Required only if
GInteractions object is supplied for x.}

\item{fg}{MatrixSelection object of matrix indices for the foreground.}

\item{bg}{MatrixSelection object of matrix indices for the background.}

\item{FUN}{Function with at least two parameters (i.e., `fg`, `bg`)
defining how enrichment should be calculated. 
Must produce a single value (numeric of length one).
The first and second parameters must represent 
fg and bg, respectively.}

\item{nBlocks}{Number of blocks for block-processing
arrays. Default is 5. Increase this for large
datasets. To read and process all data at once, set
this value to 1.}

\item{verbose}{Boolean (TRUE or FALSE) describing
whether to report block-processing progress.}

\item{BPPARAM}{Parallelization params (passed to
`BiocParallel::bplapply()`). Default is the result
of `BiocParallel::bpparams()`. Parallel processing
is not available when `by=interactions`.}

\item{...}{Additional arguments passed to
`pullHicMatrices`. See ?[`pullHicMatrices`].}
}
\value{
A DelayedMatrix of enrichment scores
 where rows are interactions (i.e. loops) and
 columns are Hi-C files.
}
\description{
Pulls Hi-C pixels and calculates the enrichment of
the selected foreground (`fg`) over the selected
background (`bg`).
}
\examples{
## Load marinerData
if (!require("marinerData", quietly = TRUE))
    BiocManager::install("marinerData")

## Read .hic file paths
hicFiles <- c(
    marinerData::LEUK_HEK_PJA27_inter_30.hic(),
    marinerData::LEUK_HEK_PJA30_inter_30.hic()
)
names(hicFiles) <- c("FS", "WT")

## Read in loops as GInteractions object
loops <-
    WT_5kbLoops.txt() |>
    setNames("WT") |>
    read.table(header=TRUE) |>
    as_ginteractions(keep.extra.columns=FALSE)

## Removes the "chr" prefix for compatibility
## with the preprocessed hic files
GenomeInfoDb::seqlevelsStyle(loops) <- 'ENSEMBL'

## Expand binSize of loops
loops <- assignToBins(x=loops, binSize=100e3)

## Calculate loop enrichment
calcLoopEnrichment(x=loops[1:10],
                   files=hicFiles)

## Customize different foreground/background
## with selection functions
buffer <- 10 # choose pixel radius around center
fg <- selectCenterPixel(mhDist=seq(0,4), buffer=buffer)
bg <- selectCorners(n=6, buffer=buffer) +
    selectOuter(n=2, buffer=buffer)

## Calculate loop enrichment
calcLoopEnrichment(x=loops[1:10],
                   files=hicFiles,
                   fg=fg,
                   bg=bg)

## Extract count matrices first
mats <- assignToBins(loops[1:10],100e3) |>
  pixelsToMatrices(buffer=10) |>
    pullHicMatrices(
    files=hicFiles,
    binSize=100e3)

## Calculate loop enrichment from count matrices 
calcLoopEnrichment(x = mats)

}
