#' @title markeR: An R Toolkit for Evaluating Gene Signatures as Phenotypic
#'   Markers
#'
#' @description The **markeR** package provides tools for evaluating gene
#' signatures across phenotypes in transcriptomics datasets (especially bulk
#' RNA-seq). It implements scoring and enrichment approaches, alongside
#' intuitive visualizations and performance metrics.
#'
#' \strong{Key features:}
#' \itemize{
#'   \item Score-based signature quantification (e.g., median-centered, ssGSEA, ranking)
#'   \item Enrichment analysis using GSEA
#'   \item Visualization of gene expression, scores, and enrichment results
#'   \item Assessment of gene set similarity
#' }
#'
#' @seealso For more information on using the markeR package, check out the
#' [markeR Documentation](https://diseasetranscriptomicslab.github.io/markeR/).
#' You can also visit the [GitHub
#' Repository](https://github.com/DiseaseTranscriptomicsLab/markeR) for the
#' latest updates and source code.
#'
#'
#' @docType package
#' @name markeR
#' @aliases markeR-package
"_PACKAGE"
