% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scones.R
\name{get_grid}
\alias{get_grid}
\title{Parse \code{scones.cv} settings}
\usage{
get_grid(c = numeric(), etas = numeric(), lambdas = numeric())
}
\arguments{
\item{c}{Numeric vector with the association scores of the SNPs. Specify it 
to automatically an appropriate range of etas and lambas.}

\item{etas}{Numeric vector with the etas to explore in the grid search. If 
ommited, it's automatically created based on the association
scores.}

\item{lambdas}{Numeric vector with the lambdas to explore in the grid search.
If ommited, it's automatically created based on the association scores.}
}
\value{
A list of \code{scones.cv} settings.
}
\description{
Creates a list composed by all \code{scones.cv} settings, with 
the values provided by the user, or the default ones if none is provided.
}
\examples{
martini:::get_grid(etas = c(1,2,3), lambdas = c(4,5,6))
martini:::get_grid(c = c(1,10,100))
}
\keyword{internal}
