% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotGeneEvents.R
\name{plotTranscripts}
\alias{plotTranscripts}
\title{Mapping and visualization of Ensembl transcripts affected by splicing.}
\usage{
plotTranscripts(events, type = c("A3SS", "A5SS", "SE", "RI", "MXE"), event_id,
  gtf, zoom = FALSE, show_PSI = TRUE)
}
\arguments{
\item{events}{a maser object.}

\item{type}{character indicating splice type. Possible values are
\code{c("A3SS", "A5SS", "SE", "RI", "MXE")}.}

\item{event_id}{numeric, event identifier.}

\item{gtf}{a \code{GRanges}, Ensembl or Gencode GTF using the hg38 build
of the human genome.}

\item{zoom}{logical, zoom to the genomic coordinates of the splice event.}

\item{show_PSI}{logical, display the PSI track.}
}
\value{
a Gviz object.
}
\description{
Mapping and visualization of Ensembl transcripts affected by splicing.
}
\details{
This is a wrapper function for performing both mapping and 
visualization of Ensembl transcripts that are compatible with the splice 
event. This function calls \code{\link{mapTranscriptsToEvents}} for 
transcript mapping, which in turn 
uses \code{findOverlaps} for transcript
 overlapping. The \code{\link[Gviz:plotTracks]{GViz}} package is used for 
 creating annotation tracks for genomic visualization of splicing events. 
 
 Each type of splice event requires a specific overlapping rule 
 (described below), #'  and a customized \code{Gviz} plot is created for 
 each splicing type.
  
  \describe{
    \item{\strong{Exon skipping}}{}
    \item{Inclusion track}{Transcript(s) overlapping the cassette exon,
     as well both flanking exons (i.e upstream and downstream exons).}
    \item{Skipping track}{Transcript(s) overlapping both flanking exons but
     not the cassettte exon.}
  }
  
  \describe{
    \item{\strong{Intron retention}}{}
    \item{Retention track}{Transcript(s) overlapping exactly the retained
     intron.}
    \item{Skipping track}{Transcript(s) where intron is spliced out and 
    overlapping both flanking exons.}
  }
  
  \describe{
  \item{\strong{Mutually exclusive exons}}{}
    \item{Exon1 track}{Transcript(s) overlapping the first exon and both 
                      flanking exons.}
    \item{Exon2 track}{Transcript(s) overlapping the second exon and both
                       flanking exons.}
  }
  
  \describe{
    \item{\strong{Alternative 3' and 5' splice sites}}{}
    \item{Short exon track}{Transcript(s) overlapping both short and 
                       downstream exons.}
    \item{Long exon track}{Transcript(s) overlapping both long and 
    downstream exons.}
  }
}
\examples{
## Create the maser object
path <- system.file("extdata", file.path("MATS_output"), package = "maser")
hypoxia <- maser(path, c("Hypoxia 0h", "Hypoxia 24h"))
hypoxia_filt <- filterByCoverage(hypoxia, avg_reads = 5)

## Ensembl GTF annotation for SRSF6
 gtf_path <- system.file("extdata", file.path("GTF", 
   "SRSF6_Ensembl85.gtf"), package = "maser")
 ens_gtf <- rtracklayer::import.gff(gtf_path)

## Retrieve gene specific splicing events
srsf6_events <- geneEvents(hypoxia_filt, geneS = "SRSF6")

## Plot exon skipping event
plotTranscripts(srsf6_events, type = "SE", event_id = 33209, gtf = ens_gtf)

}
\seealso{
\code{\link{mapTranscriptsToEvents}}
}
