% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjustData.R
\name{filterRT}
\alias{filterRT}
\title{Filter Features by Retention Time Range}
\usage{
filterRT(data, rtmin, rtmax)
}
\arguments{
\item{data}{formatted metabolomics data frame.}

\item{rtmin}{lower range of retention times for analysis. If "min",
defaults to minimum observed retention time.
.}

\item{rtmax}{upper range of retention times for analysis. If "max", defaults
to maximum observed retention time.}
}
\value{
A data frame of metabolomics features, limited to time window
\code{rtmin} \eqn{\le} rt \eqn{\le} \code{rtmax})
}
\description{
Restricts input metabolomics feature table in \code{metabData} object to a
range of retention times defined by \code{rtmin} & \code{rtmax}.
}
\details{
Retention time restriction is often recommended to aid the analysis of
comparable metabolomics datasets. The beginning and end of a chromatogram
typically contain features that do not correspond with true biological
compounds derived from the sample. \code{rtmin} and \code{rtmax} should be
set slightly before and slightly after the first and last commonly observed
metabolites, respectively.
}
