% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/methods-metabCombiner.R
\name{getAnchors}
\alias{getAnchors}
\alias{getAnchors,metabCombiner-method}
\title{Get Ordered Retention Time Pairs}
\usage{
getAnchors(object)

\S4method{getAnchors}{metabCombiner}(object)
}
\arguments{
\item{object}{metabCombiner object}
}
\value{
Data frame of anchor features
}
\description{
Returns the data frame of feature alignments used to anchor the
retention time projection model, constructed by \code{\link{selectAnchors}}.
}
\examples{
data(plasma30)
data(plasma20)

p30 <- metabData(plasma30, samples = "CHEAR")
p20 <- metabData(plasma20, samples = "Red")

p.comb <- metabCombiner(p30, p20)
p.comb <- selectAnchors(p.comb, windx = 0.05, windy = 0.03)

anchors <- getAnchors(p.comb)

}
\seealso{
\code{\link{selectAnchors}}
}
