% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/methods-metabCombiner.R
\name{getCoefficients}
\alias{getCoefficients}
\alias{getCoefficients,metabCombiner-method}
\title{Obtain Last-Used Score Coefficients}
\usage{
getCoefficients(object)

\S4method{getCoefficients}{metabCombiner}(object)
}
\arguments{
\item{object}{metabCombiner object}
}
\value{
A list of the last used weight parameters:
\item{A}{Specific weight penalizing feature m/z differences}
\item{B}{Specific weight penalizing retention time projection error}
\item{C}{Specific weight penalizing differences in abundance quantiles}
}
\description{
Provides the last used weight arguments from \code{calcScores()} function.
Returns empty list if \code{calcScores()} has not yet been called.
}
\examples{
data(plasma30)
data(plasma20)

p30 <- metabData(plasma30, samples = "CHEAR")
p20 <- metabData(plasma20, samples = "Red")

p.comb <- metabCombiner(p30, p20)
p.comb <- selectAnchors(p.comb, windx = 0.05, windy = 0.04, tolrtq = 0.15)
p.comb <- fit_gam(p.comb, k = 20, iterFilter = 1, family = "gaussian")
p.comb <- calcScores(p.comb, A = 90, B = 14, C = 0.5)

getCoefficients(p.comb)

}
