% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importQIIME2.R
\name{importQIIME2}
\alias{importQIIME2}
\alias{importQZA}
\title{Import QIIME2 results to \code{TreeSummarizedExperiment}}
\usage{
importQIIME2(
  assay.file = featureTableFile,
  featureTableFile,
  row.file = taxonomyTableFile,
  taxonomyTableFile = NULL,
  col.file = sampleMetaFile,
  sampleMetaFile = NULL,
  as.refseq = featureNamesAsRefSeq,
  featureNamesAsRefSeq = TRUE,
  refseq.file = refSeqFile,
  refSeqFile = NULL,
  tree.file = phyTreeFile,
  phyTreeFile = NULL,
  ...
)

importQZA(file, temp.dir = temp, temp = tempdir(), ...)
}
\arguments{
\item{assay.file}{\code{Character scalar}. Defines the file
path of the feature table to be imported.}

\item{featureTableFile}{Deprecated. use \code{assay.file} instead.}

\item{row.file}{\code{Character scalar} or \code{NULL}. Defines the file
path of the taxonomy table to be imported. (default:
\code{NULL}).}

\item{taxonomyTableFile}{Deprecated. use \code{row.file} instead.}

\item{col.file}{\code{Character scalar} or \code{NULL}. Defines the file path
of the sample metadata to be imported. The file has to be in tsv format.
(Default: \code{NULL}).}

\item{sampleMetaFile}{Deprecated. Use \code{col.file} instead.}

\item{as.refseq}{\code{Logical scalar} or \code{NULL}. Should the feature
names of the feature table be regarded as reference sequences? This setting
will be disregarded, if \code{refseq.file} is not \code{NULL}. If the
feature names do not contain valid DNA characters only, the reference
sequences will not be set.}

\item{featureNamesAsRefSeq}{Deprecated. Use \code{as.refseq} instead.}

\item{refseq.file}{\code{Character scalar} or \code{NULL}. Defines the file
path of the reference sequences for each feature. (Default: \code{NULL}).}

\item{refSeqFile}{Deprecated. Use \code{refseq.file} instead.}

\item{tree.file}{\code{Character scalar}. Defines the file path of
the phylogenetic tree. (Default: \code{NULL}).}

\item{phyTreeFile}{Deprecated. Use \code{tree.file} instead.}

\item{...}{additional arguments:
\itemize{
\item \code{temp.dir}: the temporary directory used for decompressing the
data. (default: \code{tempdir()})
\item \code{prefix.rm}: \code{TRUE} or \code{FALSE}: Should
taxonomic prefixes be removed? (default:
\code{prefix.rm = FALSE})
}}

\item{file}{character, path of the input qza file. Only files in format of
\code{BIOMV210DirFmt} (feature table), \code{TSVTaxonomyDirectoryFormat} (taxonomic
table), \code{NewickDirectoryFormat} (phylogenetic tree ) and
\code{DNASequencesDirectoryFormat} (representative sequences) are supported
right now.}

\item{temp.dir}{character, a temporary directory in which the qza file will
be decompressed to, default \code{tempdir()}.}

\item{temp}{Deprecated. Use \code{temp.dir} instead.}
}
\value{
A
\code{\link[TreeSummarizedExperiment:TreeSummarizedExperiment-class]{TreeSummarizedExperiment}}
object

\code{matrix} object for feature table, \code{DataFrame} for taxonomic table,
\code{\link[ape:read.tree]{ape::phylo}} object for phylogenetic tree,
\code{\link[Biostrings:XStringSet-class]{Biostrings::DNAStringSet}} for representative sequences of taxa.
}
\description{
Results exported from QIMME2 can be imported as a
\code{TreeSummarizedExperiment} using \code{importQIIME2}. Except for the
\code{assay.file}, the other data types, \code{row.file},
\code{refseq.file} and \code{tree.file}, are optional, but are highly
encouraged to be provided.

Import the QIIME2 artifacts to R.
}
\details{
Both arguments \code{as.refseq} and \code{refseq.file} can be used
to define reference sequences of features. \code{as.refseq} is
only taken into account, if \code{refseq.file} is \code{NULL}. No reference
sequences are tried to be created, if \code{featureNameAsRefSeq} is
\code{FALSE} and \code{refseq.file} is \code{NULL}.
}
\examples{
assay.file <- system.file("extdata", "table.qza", package = "mia")
row.file <- system.file("extdata", "taxonomy.qza", package = "mia")
col.file <- system.file("extdata", "sample-metadata.tsv", package = "mia")
tree.file <- system.file("extdata", "tree.qza", package = "mia")
refseq.file <- system.file("extdata", "refseq.qza", package = "mia")
tse <- importQIIME2(
  assay.file = assay.file,
  row.file = row.file,
  col.file = col.file,
  refseq.file = refseq.file,
  tree.file = tree.file
)

tse
# Read individual files
assay.file <- system.file("extdata", "table.qza", package = "mia")
row.file <- system.file("extdata", "taxonomy.qza", package = "mia")
col.file <- system.file("extdata", "sample-metadata.tsv", package = "mia")

assay <- importQZA(assay.file)
rowdata <- importQZA(row.file, prefix.rm = TRUE)
coldata <- read.table(col.file, header = TRUE, sep = "\t", comment.char = "")

# Assign rownames 
rownames(coldata) <- coldata[, 1]
coldata[, 1] <- NULL

# Order coldata based on assay
coldata <- coldata[match(colnames(assay), rownames(coldata)), ]

# Create SE from individual files
se <- SummarizedExperiment(
    assays = list(assay), rowData = rowdata, colData = coldata)
se

}
\references{
Bolyen E et al. 2019: Reproducible, interactive, scalable and extensible
microbiome data science using QIIME 2. Nature Biotechnology 37: 852–857.
\url{https://doi.org/10.1038/s41587-019-0209-9}

\url{https://qiime2.org}
}
\seealso{
\code{\link[=convertFromPhyloseq]{convertFromPhyloseq}}
\code{\link[=convertFromBIOM]{convertFromBIOM}}
\code{\link[=convertFromDADA2]{convertFromDADA2}}
\code{\link[=importMothur]{importMothur}}
}
\author{
Yang Cao
}
