% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mvrnorm_sim.R
\name{timepoint_process}
\alias{timepoint_process}
\title{Function for processing and checking the inputed timepoints}
\usage{
timepoint_process(
  num_timepoints,
  t_interval,
  n,
  asynch_time,
  missing_per_subject
)
}
\arguments{
\item{num_timepoints}{either an integer value specifying the number of
timepoints per subject or a vector of timepoints for each subject. If
supplying a vector the lenght of the vector must equal the total number of
subjects.}

\item{t_interval}{numeric vector of length two specifying the interval of
time from which to draw observatoins [t_1, t_q]. Assumed to be equally
spaced over the interval unless \code{asynch_time} is set to TRUE.}

\item{n}{numeric value representing the total number of obserations}

\item{asynch_time}{logical indicator designed to randomly sample timepoints
over a specified interval if set to TRUE.}
}
\value{
Returns a list of the number of timepoints and the times for each unit
}
\description{
To allow for increased flexibility the user may specify the number of
timepoints as either a single value or separately for each individual. There
is also an added option about whether to draw the timepoints evenly spaced
across the interval of interest or whether to randomly draw them.
}
\details{
It is assummed that there is a known time interval of interest over which
samples will be collected longitudinally on subjects. This interval is
specified as [t_1, t_q]. All subjects are assumed to have baseline
observations, i.e., t_1.

Over this study interval each subject can have a potentially different number
of measurements taken. In the most simple case we assume that all subjects
will have the same number of measurements and can specify
\code{num_timepoints} as a single scalar value. Otherwise, we must specify
how many timepoints will be collected for each individual. In this latter
case \code{num_timepoints} must have the same length as the number of
subjects.

Finally, we can select whether we want the timepoints to be drawn at equal
spaces over our study interal, or whether we want to randomly sample
asynchronous timepoints. In the asynchronous case we randomly draw from a
uniform distribution over the study interval with the restriction that the
first observation must occur at t_1.
}
\keyword{internal}
