% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inter_functions.R
\name{plotHeatmap}
\alias{plotHeatmap}
\title{Plot heatmap}
\usage{
plotHeatmap(
  aggdat,
  features = NULL,
  log = TRUE,
  sort_by = c("Fano", "MAD", "Variance"),
  nfeat = 50,
  col_by = NULL,
  row_by = NULL,
  plotTitle = ""
)
}
\arguments{
\item{aggdat}{aggregated MRExperiment}

\item{features}{Vector of features to plot. If NULL, the top `nfeat`
features in terms of `sort_by` will be plotted.}

\item{log}{Log2 transform data. Default is TRUE.}

\item{sort_by}{Dispersion measure to sort features, one of "Fano", "MAD",
and "Variance"}

\item{nfeat}{Number of features to display. Default is 50.}

\item{col_by}{Vector of phenotypes for coloring.}

\item{row_by}{Name of feature level for coloring.}

\item{plotTitle}{Plot title. By default, no title.}
}
\value{
plotly heatmap
}
\description{
This function plots a heatmap of feature abundance.
}
\examples{
data("mouseData", package = "metagenomeSeq")
aggdat <- aggFeatures(mouseData, level = "genus")
plotHeatmap(aggdat, sort_by = "Fano")

}
