% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotNhoods.R
\name{plotNhoodGraph}
\alias{plotNhoodGraph}
\title{Plot graph of neighbourhood}
\usage{
plotNhoodGraph(
  x,
  layout = "UMAP",
  colour_by = NA,
  subset.nhoods = NULL,
  size_range = c(0.5, 3),
  node_stroke = 0.3,
  is.da = FALSE,
  highlight.da = FALSE,
  ...
)
}
\arguments{
\item{x}{A \code{\linkS4class{Milo}} object}

\item{layout}{this can be (a) a character indicating the name of the \code{reducedDim} slot in the
\code{\linkS4class{Milo}} object to use for layout (default: 'UMAP') (b) an igraph layout object}

\item{colour_by}{this can be a data.frame of milo results or a character corresponding to a column in colData}

\item{subset.nhoods}{A logical, integer or character vector indicating a subset of nhoods to show in plot
(default: NULL, no subsetting). This is necessary if \code{testNhoods} was run using \code{subset.nhoods=...}.}

\item{size_range}{a numeric vector indicating the range of node sizes to use for plotting (to avoid overplotting
in the graph)}

\item{node_stroke}{a numeric indicating the desired thickness of the border around each node}

\item{is.da}{logical scalar that tells plotNhoodGraph to order nhoods by |LFC| which can help to visually
emphasise which nhoods are DA.}

\item{highlight.da}{logical or numeric scalar that emphasises the DA nhoods in the layout by adjusting the transparency
of the non-DA nhoods. Can only be used if \code{is.da=TRUE}, otherwise will give a warning. If highlight.da is a numeric
then it explicitly sets the transparency level (must be between 0 and 1). If highlight.da is logical then the
transparency is set to 0.1}

\item{...}{arguments to pass to \code{ggraph}}
}
\value{
a \code{ggplot-class} object
}
\description{
Visualize graph of neighbourhoods
}
\examples{
NULL

}
\author{
Emma Dann
}
