% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fdrSig.R
\name{fdrSig}
\alias{fdrSig}
\title{fdrSig Ruturns FDR significant miRNA/mRNA predictions}
\usage{
fdrSig(RMObj, value = 0.05, method = "fdr")
}
\arguments{
\item{RMObj}{The output of runModels}

\item{value}{The FDR value default is 0.1}

\item{method}{The p-value adjustment method default is fdr. It could be either of the following "holm", "hochberg",
"hommel","bonferroni", "BH", "BY", or "fdr".}
}
\value{
A list of FDR corrected p vlaues, annova, and significance for each gene and the miRNA/s of interest
}
\description{
This function performs FDR correction on the p_values generated by the runModels function list.
}
\examples{
models <- runModels(Combine, geneVariant, "ebv-mir-bart9-5p")
x <- fdrSig(models, value = 0.1, method = "fdr")
}
\keyword{correction}
\keyword{p_adjust,}
