% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bam_functions.R
\name{bam2R_10x}
\alias{bam2R_10x}
\title{Read nucleotide counts from a 10x Genomics .bam file}
\usage{
bam2R_10x(
  file,
  sites = "MT:1-16569",
  q = 25,
  mq = 0,
  s = 2,
  head.clip = 0,
  max.depth = 1e+06,
  verbose = FALSE,
  mask = 0,
  keepflag = 0,
  max.mismatches = NULL,
  ncores = 1,
  ignore_nonstandard = FALSE,
  min_reads_per_barcode = 50
)
}
\arguments{
\item{file}{The file location of the BAM file as a string.}

\item{sites}{The chromosome locations of interest in BED format as
a string. Alternatively a single GRanges object will also work.}

\item{q}{An optional cutoff for the nucleotide Phred
quality. Default q = 25. Nucleotides with Q < q will be masked
by 'N'.}

\item{mq}{An optional cutoff for the read mapping quality. Default
mq = 0 (no filter). reads with MQ < mq will be discarded.}

\item{s}{Optional choice of the strand. Defaults to s = 2 (both).}

\item{head.clip}{Should n nucleotides from the head of reads be
clipped? Default 0.}

\item{max.depth}{The maximal depth for the pileup command. Default
1,000,000.}

\item{verbose}{Boolean. Set to TRUE if you want to get additional
output.}

\item{mask}{Integer indicating which flags to filter. Default 0 (no
mask). Try 1796 (BAM_DEF_MASK).}

\item{keepflag}{Integer indicating which flags to keep. Default 0
(no mask). Try 3 (PAIRED|PROPERLY_PAIRED).}

\item{max.mismatches}{Integer indicating maximum MN value to allow
in a read. Default NULL (no filter).}

\item{ncores}{Integer indicating the number of threads to use for
the parallel function call that summarize the results for each
bam file. Default 1.}

\item{ignore_nonstandard}{Boolean indicating whether or not gapped
alignments, insertions, or deletions should be included in the
final output. Default FALSE. If you have an inflation of
spliced mitochondrial reads it is recommended to set this to
TRUE.}

\item{min_reads_per_barcode}{Int defining how many reads a barcode
must for it to be considered in the pileup tabulations. Default 50}
}
\value{
A named \code{\link{list}} of \code{\link{matrix}} with
rows corresponding to genomic positions and columns for the
nucleotide counts (A, T, C, G, -), masked nucleotides (N),
(INS)ertions, (DEL)etions that count how often a read begins
and ends at the given position, respectively. Each member of
the list corresponds to an invididual cells or entity based on
the cell barcode of interest. The names of the elements of the
list correspond to the respective cell barcodes.  For the
intents and purposes of the mitoClone2 package this object is
equivalent to the output from the
\code{\link{baseCountsFromBamList}} function.  The returned
list has a variable length depending on the ignore_nonstandard
parameter and each element contains a matrix has 8 columns and
(stop - start + 1) rows. The two strands have their counts
merged. If no counts are present in the provided sites
parameter nothing will be returned.  IMPORTANT: The names of
the list will NOT reflect the source filename and will
exclusively be named based on the respective the barcodes
extracted from said file. If merging multiple datasets, it is
important to change the list's names once imported to avoid
naming collisions.
}
\description{
This function uses a C interface to read the nucleotide counts on
each position of a .bam alignment. The counts are individually
tabulated for each cell barcode as specified by the user. The
counts of both strands are reported separately and nucleotides
below a quality cutoff are masked.
}
\details{
This code is an adaption of code that was originally written by
Moritz Gerstung for the deepSNV package
}
\examples{
bamCounts <- bam2R_10x(file = system.file("extdata",
"mm10_10x.bam", package="mitoClone2"), sites="chrM:1-15000")
}
\author{
Benjamin Story (adapted from original code with permission
from Moritz Gerstung)
}
