% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impute.nipals.R
\name{impute.nipals}
\alias{impute.nipals}
\title{Impute missing values using NIPALS algorithm}
\usage{
impute.nipals(X, ncomp, ...)
}
\arguments{
\item{X}{A numeric matrix containing missing values}

\item{ncomp}{Positive integer, the number of components to derive from
\code{X} using the \code{\link{nipals}} function and reconstitute
the original matrix}

\item{...}{Optional arguments passed to \code{\link{nipals}}}
}
\value{
A numeric matrix with missing values imputed.
}
\description{
This function uses \code{\link{nipals}} function to decompose
\code{X} into a set of components (\code{t}), (pseudo-) singular-values
(\code{eig}), and feature loadings (\code{p}). The original matrix is then
approximated/reconstituted using the following equation:
\deqn{\hat{X} = t * diag(eig) * t(p)} 
The missing values from \code{X} are then approximated from this matrix. It
is best to ensure enough number of components are used in order to best
impute the missing values.
}
\examples{
data("nutrimouse")
X <- data.matrix(nutrimouse$lipid)
## add missing values to X to impute and compare to actual values
set.seed(42)
na.ind <- sample(seq_along(X), size = 10)
true.values <- X[na.ind]
X[na.ind] <- NA
X.impute <- impute.nipals(X = X, ncomp = 5)
## compare
round(X.impute[na.ind], 2)
true.values
}
\seealso{
\code{\link{impute.nipals}}, \code{\link{pca}}
}
\author{
Al J Abadi
}
