% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mnems.r
\name{scoreAdj}
\alias{scoreAdj}
\title{Network score}
\usage{
scoreAdj(
  D,
  adj,
  method = "llr",
  marginal = FALSE,
  logtype = 2,
  weights = NULL,
  trans.close = TRUE,
  subtopo = NULL,
  prior = NULL,
  ratio = TRUE,
  fpfn = c(0.1, 0.1),
  Rho = NULL,
  dotopo = FALSE,
  P = NULL,
  oldadj = NULL,
  modified = TRUE
)
}
\arguments{
\item{D}{data matrix; use modified = FALSE}

\item{adj}{adjacency matrix of the network phi}

\item{method}{either llr if D consists of log odds or disc,
if D is binary}

\item{marginal}{logical to compute the marginal likelihood (TRUE)}

\item{logtype}{log base of the log odds}

\item{weights}{a numeric vector of weights for the columns of D}

\item{trans.close}{if TRUE uses the transitive closure of adj}

\item{subtopo}{optional matrix with the subtopology theta as
adjacency matrix}

\item{prior}{a prior network matrix for adj}

\item{ratio}{if FALSE uses alternative distance for the model score}

\item{fpfn}{numeric vector of length two with false positive and
false negative rates}

\item{Rho}{optional perturbation matrix}

\item{dotopo}{if TRUE computes and returns the subtopology theta (optional)}

\item{P}{previous score matrix (only used internally)}

\item{oldadj}{previous adjacency matrix (only used internally)}

\item{modified}{if TRUE, assumes a prepocessed data matrix}
}
\value{
transitively closed matrix or graphNEL
}
\description{
Computes the fit (score of a network) of the data given a network matrix
}
\examples{
D <- matrix(rnorm(100*3), 100, 3)
colnames(D) <- 1:3
rownames(D) <- 1:100
adj <- diag(3)
colnames(adj) <- rownames(adj) <- 1:3
scoreAdj(D, adj)
}
\author{
Martin Pirkl
}
