% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RNAdistribution.R
\name{RNAdistribution}
\alias{RNAdistribution}
\title{Plot the distribution of sRNA classes based on nucleotide length}
\usage{
RNAdistribution(
  data,
  samples = NULL,
  style,
  data.type = "samples",
  facet = TRUE,
  facet.arrange = 3,
  colour = "#0868AC",
  outline = "black",
  wrap.scales = "fixed",
  overlap = TRUE,
  relative = FALSE,
  non.classified = TRUE
)
}
\arguments{
\item{data}{data.frame; generated originally by \code{\link[=RNAimport]{RNAimport()}}}

\item{samples}{character; states a subset of samples to plot. This argument
is based on the sample names within the data.}

\item{style}{character; \code{style="line"} or \code{style="bar"}.
Instructs how to plot the data. Where \code{style="line"} plots a line graph
and \code{style="bar"} plots a bar graph.}

\item{data.type}{character; either plotting "samples" or the "consensus"
stored in the 'DicerConsensus' column.}

\item{facet}{logical; forms a matrix of panels defined by row and column
faceting variables. It plots the results for each sample as a bar chart
and contains it within a single plot. The number of rows in the facet can
be changed using the argument \code{facet.arrange}.
Default \code{facet = TRUE} , plots each sample separately when
\code{facet = FALSE} .}

\item{facet.arrange}{numeric; value supplied to define the number of columns
to include in the facet. This argument is piped into the \code{ ncol}  argument in
\code{\link[ggplot2:facet_wrap]{ggplot2::facet_wrap()}} to define the number of columns. By default, this is
set to 3.}

\item{colour}{character; fill colour, Default is "#0868AC".}

\item{outline}{character; states the outline colour for a box plot.
Default is "black".}

\item{wrap.scales}{character; scales be fixed ("fixed", the default), free
("free"), or free in one dimension ("free_x", "free_y")}

\item{overlap}{logical; generates a single line graph, containing all
sample replicate information. Default \code{overlap=TRUE}.}

\item{relative}{logical; used in conjunction with \code{data.type="consensus"}.
Instructs plotting of the relative frequency of all sRNA classes across the
data defined by the consensus dicer-derived sRNA column (see
\code{\link[=RNAdicercall]{RNAdicercall()}} function for more information).}

\item{non.classified}{logical; to include distribution of sRNAs which were
unclassified. Default is TRUE, ie. maintain.}
}
\value{
The function returns a list containing the results: a data frame and
the plot(s). To access an element, simply use the "$" symbol,
and the elements "data" and "plot" will appear.
}
\description{
\code{RNAdistribution} plots the distribution of dicer-derived
sRNA classes across samples or the sRNA consensus determined by the
\code{\link[=RNAdicercall]{RNAdicercall()}} function. This can be displayed as a line or bar
plot.
}
\details{
The function can be used to plot a variety of different comparisons and plots.
It can be used to plot the distribution of sRNA classes within each sample
replicate, which can be represented as a bar chart \code{style="bar"} or a
line graph \code{style="line"}. These plots can be represented individually or
in a single facet plot when \code{facet="TRUE"}.

Additionally, there is the option to plot the distribution of sRNA classes
within individual samples or to plot the distribution of the consensus
dicer-derived sRNA classes determined by the \code{\link[=RNAdicercall]{RNAdicercall()}} function and
stored in the column \code{DicerConsensus} when \code{data.type="consensus"}.
When plotting samples individually, there is the option to overlap the
results onto a single line graph when \code{overlap=TRUE}. This is not an
option for bar plots.
}
\examples{
# load data 
data('sRNA_data')

p1 <- RNAdistribution(data = sRNA_data, style = "line")

p2 <- RNAdistribution(data = sRNA_data, style = "line", overlap = FALSE)

p3 <- RNAdistribution(data = sRNA_data, style = "bar")

p3.2 <- RNAdistribution(data = sRNA_data, style = "bar",
                       samples = c("heterograft_1", "heterograft_2",
                       "heterograft_3"))

p4 <- RNAdistribution(data = sRNA_data, style = "bar", facet = FALSE)

p5 <- RNAdistribution(data = sRNA_data, style = "bar",
                      facet = TRUE, facet.arrange = 2 )


# Run function to define sRNA class for each cluster.
sRNA_data_dicercall <- mobileRNA::RNAdicercall(data = sRNA_data, tidy=TRUE)

p6 <- RNAdistribution(data = sRNA_data_dicercall, style = "bar", data.type = "consensus")

}
