% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RNAreorder.R
\name{RNAreorder}
\alias{RNAreorder}
\title{Reorder the data frame for differential analysis, ensuring control verse
treatment comparison}
\usage{
RNAreorder(data, controls)
}
\arguments{
\item{data}{data.frame; generated by \code{\link[=RNAimport]{RNAimport()}}}

\item{controls}{character; vector of control condition sample names.}
}
\value{
A re-ordered/re-organised working data frame with control samples
after the 5 cluster information columns, and treatment sample columns after
the control sample columns.
}
\description{
Re-organise the working data frame, placing control samples
before treatment samples. This ensures differential analysis comparison
between controls and treatment are in the correct arrangement.
}
\examples{
# load data 
data("sRNA_data")

controlReps <- c("selfgraft_1", "selfgraft_2", "selfgraft_3")

reorder_df <- RNAreorder(data = sRNA_data, controls = controlReps)

}
