% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{network_edge_strength}
\alias{network_edge_strength}
\title{Count edges in an adjacency matrix using different cut-off thresholds.}
\usage{
network_edge_strength(adjm)
}
\arguments{
\item{adjm}{A symmetrix numeric matrix.}
}
\value{
A numeirc matrix of \code{dim(max(adjm), 2)}. The first column 
indicated the applied threshold, the second column the remaining edges.
}
\description{
Computes the how many edges remain in a network if edges with a weight 
lower than a certain threshold are removed.
The number of remaining edges between 1 and max(adjm) are calculated.
It is assumend that the matrix is symmetric and therefore the number 
of edges divided by two.
Uses the function \code{\link{replace_values}}.
}
\examples{
m <- matrix(seq(1:16), nrow=4)
# m <- matrix(rnorm(10000), nrow=100)
# bics <- c(run_fabia(m), run_isa(m), run_plaid(m))
# fn <- feature_network(bics, m)
# network_edge_strength(apply_threshold(fn))

}
