% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/motifStack.R
\name{motifStack}
\alias{motifStack}
\title{plot a DNA sequence logo stack}
\usage{
motifStack(
  pfms,
  layout = c("stack", "treeview", "phylog", "radialPhylog"),
  reorder = TRUE,
  ...
)
}
\arguments{
\item{pfms}{a list of objects of class \link{pfm}}

\item{layout}{layout of the logo stack, stack, treeview or radialPhylog}

\item{reorder}{logical(1). Default TRUE. Set to FALSE will do alignment but
keep the order of the pfms. This parameter only work for stack layout.}

\item{\dots}{any parameters could to pass to \link{plotMotifLogoStack},
\link{plotMotifLogoStackWithTree}, \link{plotMotifStackWithPhylog} or
\link{plotMotifStackWithRadialPhylog}.
And the `revcomp` parameter for \link{DNAmotifAlignment}.}
}
\value{
return a list contains pfms and phylog
}
\description{
Plot a DNA sequence logo stack
}
\examples{

  if(interactive() || Sys.getenv("USER")=="jianhongou"){
    library("MotifDb")
    matrix.fly <- query(MotifDb, "Dmelanogaster")
    motifs <- as.list(matrix.fly)
    motifs <- motifs[grepl("Dmelanogaster-FlyFactorSurvey-", 
                            names(motifs), fixed=TRUE)]
    names(motifs) <- gsub("Dmelanogaster_FlyFactorSurvey_", "", 
                gsub("_FBgn[0-9]+$", "", 
                  gsub("[^a-zA-Z0-9]","_", 
                     gsub("(_[0-9]+)+$", "", names(motifs)))))
    motifs <- motifs[unique(names(motifs))]
    pfms <- sample(motifs, 50)
    pfms <- mapply(pfms, names(pfms), FUN=function(.ele, .name){
                 new("pfm",mat=.ele, name=.name)})
    motifStack(pfms, "radialPhylog")
    
    ## AA motifs
    pcms<-importMatrix(system.file("extdata", "prot.meme", 
                                   package="motifStack"),
                   format="meme", to="pfm")
    motifStack(pcms[1:5])
    motifStack(pcms[1:5], reorder=FALSE)
  }

}
