% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotMotifLogoStackWithTree.R
\name{plotMotifLogoStackWithTree}
\alias{plotMotifLogoStackWithTree}
\title{plot sequence logos stack with hierarchical cluster tree}
\usage{
plotMotifLogoStackWithTree(pfms, hc, treewidth = 1/8, trueDist = FALSE, ...)
}
\arguments{
\item{pfms}{a list of position frequency matrices, pfms must be a list of
class pfm}

\item{hc}{an object of the type produced by stats::hclust}

\item{treewidth}{the width to show tree}

\item{trueDist}{logical flags to use hclust height or not.}

\item{...}{other parameters can be passed to plotMotifLogo function}
}
\value{
none
}
\description{
plot sequence logos stack with hierarchical cluster tree
}
\examples{

  #####Input#####
  pcms<-readPCM(file.path(find.package("motifStack"), "extdata"),"pcm$")

  #####Clustering#####
  hc <- clusterMotifs(pcms)

  ##reorder the motifs for plotMotifLogoStack
  motifs<-pcms[hc$order]
  motifs <- lapply(motifs, pcm2pfm)
  ##do alignment
  motifs<-DNAmotifAlignment(motifs)
  ##plot stacks
  plotMotifLogoStack(motifs, ncex=1.0)
  plotMotifLogoStackWithTree(motifs, hc=hc)

}
