% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{homer}
\alias{homer}
\title{MotifDb object containing motif information from motif databases included in
HOMER.}
\format{
\code{\link[MotifDb]{MotifDb}} object of length 247; to access metadata
use mcols(homer)
\describe{
 \item{providerName}{Name provided HOMER}
 \item{providerId}{Factor Name provided by HOMER}
 \item{dataSource}{\code{"HOMER"}}
 \item{geneSymbol}{Symbol provided by HOMER}
 \item{geneId}{Entrez gene id for the transcription factor}
 \item{geneIdType}{\code{"ENTREZ"}}
 \item{proteinId}{UNIPROT id for the transcription factor}
 \item{proteinIdType}{\code{"UNIPROT"}}
 \item{organism}{\code{"Hsapiens"}}
 \item{sequenceCount}{\code{NA}}
 \item{bindingSequence}{Consensus sequence for the motif}
 \item{bindingDomain}{DBD provided by HOMER}
 \item{tfFamily}{\code{NA}}
 \item{experimentType}{The Celltype, IP, Assay, and GEO id if applicable for the motif}
 \item{pubmedID}{\code{"20513432"} see \code{Source} for more details}
}
}
\source{
Heinz S, Benner C, Spann N, Bertolino E et al. (2010 May 28) Simple Combinations
  of Lineage-Determining Transcription Factors Prime cis-Regulatory
  Elements Required for Macrophage and B Cell Identities. Mol Cell, \bold{38(4):576-589}.
  PMID: \href{http://www.ncbi.nlm.nih.gov/sites/entrez?Db=Pubmed&term=20513432[UID]}{20513432}
}
\usage{
homer
}
\value{
\code{\link[MotifDb]{MotifList-class}} object
}
\description{
From the website: "Homer includes several motif databases that are used to help annotate
results and conduct searches for known motifs.  HOMER contains a custom motif
database based on independent analysis of mostly ChIP-Seq data sets which is
heavily utilized in the software." See \url{http://homer.salk.edu/homer/motif/motifDatabase.html}
for more information on how these files were generated, and Homer's sources.
}
\details{
Load with \code{data(homer)}
}
\examples{
data(homer)
homer
}
\seealso{
\url{http://homer.salk.edu/homer/index.html} \url{http://homer.salk.edu/homer/motif/motifDatabase.html}
  \url{http://homer.salk.edu/homer/motif/HomerMotifDB/homerResults.html}
}
\keyword{datasets}
