% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count_wrapper.R
\name{hitStrand}
\alias{hitStrand}
\title{Hit strand}
\usage{
hitStrand(seq, pfm, bg, threshold = NULL)
}
\arguments{
\item{seq}{A DNAString object}

\item{pfm}{An R matrix that represents a position frequency matrix}

\item{bg}{A Background object}

\item{threshold}{Score threshold for calling motif matches. If NULL,
the threshold will determined from alpha.}
}
\value{
\describe{
\item{hits}{Vector of motif hits on the given strand}
}
}
\description{
This function computes the per-position
motif matches in a given DNA strand.
}
\details{
The function returns the per-position scores
for the given strand. If the sequence is too short,
it contains an empty vector.
}
\examples{


# Load sequences
seqfile = system.file("extdata", "seq.fasta", package = "motifcounter")
seqs = Biostrings::readDNAStringSet(seqfile)

# Load background
bg = readBackground(seqs, 1)

# Load motif
motiffile = system.file("extdata", "x31.tab", package = "motifcounter")
motif = t(as.matrix(read.table(motiffile)))

# Compute the per-position and per-strand scores
motifcounter:::hitStrand(seqs[[1]], motif, bg)

}
