% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/background_wrapper.R
\name{readBackground}
\alias{readBackground}
\title{Estimates a background model from a set of DNA sequences}
\usage{
readBackground(seqs, order = 1)
}
\arguments{
\item{seqs}{A DNAStringSet object}

\item{order}{Order of the Markov models that shall be used as the
background model. Default: order = 1.}
}
\value{
A Background object
}
\description{
Given a set of DNA sequences and an order, this function
estimates an order-d Markov model which is used to characterize
random DNA sequences.
}
\examples{

# Load sequences
file = system.file("extdata", "seq.fasta", package = "motifcounter")
seqs = Biostrings::readDNAStringSet(file)

# Estimate an order-1 Markov model
bg = readBackground(seqs, 1)

}
