% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_wrapper.R
\name{scoreDistEmpirical}
\alias{scoreDistEmpirical}
\title{Empirical score distribution}
\usage{
scoreDistEmpirical(pfm, bg, seqlen, nsim)
}
\arguments{
\item{pfm}{An R matrix that represents a position frequency matrix}

\item{bg}{A Background object}

\item{seqlen}{Integer-valued vector that defines the lengths of the
individual sequences. For a given DNAStringSet, 
this information can be retrieved using \code{\link{numMotifHits}}.}

\item{nsim}{Integer number of random samples.}
}
\value{
List containing
\describe{
\item{scores}{Vector of scores}
\item{dist}{Score distribution}
}
}
\description{
This function estimates the empirical score distribution
on a set of randomly generated DNA sequences based on the
background model.
This function is only used for benchmarking analysis.
}
\examples{

# Load sequences
seqfile = system.file("extdata", "seq.fasta", package = "motifcounter")
seqs = Biostrings::readDNAStringSet(seqfile)

# Load background
bg = readBackground(seqs, 1)

# Load motif
motiffile = system.file("extdata", "x31.tab", package = "motifcounter")
motif = t(as.matrix(read.table(motiffile)))


# Compoute the empirical score distribution in
# sequences of length 1kb using 1000 samples
motifcounter:::scoreDistEmpirical(motif, bg, seqlen = 1000, nsim = 1000)

}
\seealso{
\code{\link{scoreDist}}
}
