% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/consensusSLP.R
\name{cons_slp}
\alias{cons_slp}
\title{Identify consensus SLPs}
\usage{
cons_slp(screen_slp, tumour_slp)
}
\arguments{
\item{screen_slp}{screen hits data annotated with SLPs information, generated by \code{\link{scr_slp}}.}

\item{tumour_slp}{the merged SLPs data predicted by \code{\link{corr_slp}} and \code{\link{comp_slp}}.}
}
\value{
A data.table.
  \describe{
    \item{mut_entrez}{Entrez ids of mutations.}
    \item{mut_symbol}{Gene symbols of mutations.}
    \item{cons_slp_entrez}{Entrez ids of consensus SLPs.}
    \item{cons_slp_symbol}{Gene symbols of Consensus SLPs.}
    \item{cell_1, cell_2}{From which pair of cell lines the consensus SLPs predicted.}
    \item{judgement}{Judgement based on Cohen's Kappa.}
    \item{kappa_value}{Cohen's Kappa coefficient}
    \item{pvalue}{pvalue for Cohen's Kappa coefficient.}
    \item{fdr}{"BH" adjusted pvalue via \code{\link[stats]{p.adjust}}.}
}
}
\description{
Identify consensus SLPs based on Cohen's Kappa or hypergeometric test.
}
\details{
Consensus SLPs are enriched screen hits that are SLPs of same mutations in different cell lines.
  For each common mutation, the SLPs predicted from human tumour data are used as the total sets.
  We used either Cohen's Kappa coefficient on a confusion matrix, or Hypergeometric test, to test
  the signficance of overlapping of screen hits.
}
\examples{
#- See the examples in the vignette.
if (FALSE) k_res <- cons_slp(scr_res, merged_res)
}
\references{
Landis JR, Koch GG (1977) The measurement of observer agreement for categorical data. Biomet-rics, 33: 159-174.
}
