% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search.R
\name{search_multimir}
\alias{search_multimir}
\alias{search.multimir}
\title{Search the multiMiR Database Given a MySQL Query}
\usage{
search_multimir(query)

search.multimir(query)
}
\arguments{
\item{query}{a character string for the MySQL query.}
}
\value{
\code{search_multimir} returns a data frame containing results from
the multiMiR web server.
}
\description{
This is a function for directly querying the multiMiR database with MySQL
queries. Given a MySQL query, it searches and retrieves result from the
multiMiR database on the multiMiR web server. To use \code{search_multimir}
directly, users will need to be familiar with MySQL and multiMiR table
structures. Users are advised to use \code{get_multimir} instead.
}
\details{
search.multimir() has been deprecated and replaced with the search_multimir()
version.
}
\examples{

  ## show all tables in the multiMiR database
  tables <- search_multimir(query="show tables")

  ## show the structure of table diana_microt
  microt <- search_multimir(query="describe diana_microt")

  ## search for validated target genes of hsa-miR-18a-3p in miRecords
  qry <- paste("SELECT m.mature_mirna_acc, m.mature_mirna_id,",
               "    t.target_symbol, t.target_entrez, t.target_ensembl,",
               "    i.experiment, i.support_type, i.pubmed_id",
               "FROM mirna AS m INNER JOIN mirecords AS i INNER JOIN target",
               "AS t ON (m.mature_mirna_uid=i.mature_mirna_uid AND",
               "    i.target_uid=t.target_uid)",
               "WHERE m.mature_mirna_id='hsa-miR-18a-3p'")
  result <- search_multimir(query = qry)

}
\keyword{database}
\keyword{utilities}
