% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preservation.R
\name{PreservationPermutationTest}
\alias{PreservationPermutationTest}
\title{PreservationPermutationTest}
\usage{
PreservationPermutationTest(
  referenceDatExpr,
  design,
  constructNetworksIn,
  testPreservationIn,
  nPermutations = 100,
  nPresPermutations = 100,
  ...
)
}
\arguments{
\item{referenceDatExpr}{the combined datExpr}

\item{design}{the sampleTable}

\item{constructNetworksIn}{the condition to use for network construction, e.g. for the astrocyte data, this is "EAE"}

\item{testPreservationIn}{the condition to use for testing preservation, e.g. for the astrocyte data, this was "WT"}

\item{nPermutations}{the number of permutations to perform for permutation test}

\item{nPresPermutations}{the number of permutations to perform in modulePreservation function}

\item{...}{arguments to pass to blockwiseModules function for network construction (should be the same as used for constructing the original network)}
}
\value{
A list of data.frames with preservation results for each permutation
}
\description{
Performs a permutation test to determine if a null distribution of expected
preservation scores for modules in this dataset if the labels were 
randomly assigned. Please look at the astrocyte vignette for more info.
}
\examples{
\dontrun{
library(ExperimentHub)
eh = ExperimentHub()
eh_query = query(eh, c("multiWGCNAdata"))
astrocyte_networks = eh_query[["EH8222"]] 
astrocyte_se = eh_query[["EH8223"]] 
sampleTable = colData(astrocyte_se)
results = list()
results$permutation.test = PreservationPermutationTest(astrocyte_networks$combined@datExpr[sample(17000,3000),], 
                                                       sampleTable, 
                                                       constructNetworksIn = "EAE", # Construct networks using EAE samples
                                                       testPreservationIn = "WT", # Test preservation of disease samples in WT samples
                                                       nPermutations = 10, # Number of permutations for permutation test
                                                       nPresPermutations = 10, # Number of permutations for modulePreservation function
                                                       networkType = "signed", TOMType = "unsigned", 
                                                       power = 12, minModuleSize = 100, maxBlockSize = 25000,
                                                       reassignThreshold = 0, minKMEtoStay = 0, mergeCutHeight = 0,
                                                       numericLabels = TRUE, pamRespectsDendro = FALSE, 
                                                       deepSplit = 4, verbose = 3
                                                       )
}
}
\author{
Dario Tommasini
}
