% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overlaps.R
\name{overlapComparisons}
\alias{overlapComparisons}
\title{Overlap comparisons}
\usage{
overlapComparisons(
  comparisonList,
  WGCNAlist,
  first,
  second,
  element,
  plot = TRUE,
  write = FALSE
)
}
\arguments{
\item{comparisonList}{a list passed by the iterate function}

\item{WGCNAlist}{list of objects of class WGCNA}

\item{first}{index of first WGCNA object}

\item{second}{index of second WGCNA object}

\item{element}{element position in the comparison list (passed by iterate function)}

\item{plot}{generate plots?}

\item{write}{write results to file?}
}
\value{
A list, in which the first element is a data.frame showing the 
overlap results and the second element is a data.frame showing the best 
matching modules between the two WGCNA objects.
}
\description{
Compares modules between two objects of type WGCNAobjects
within a WGCNAobject list given the indices. Recommended to be used in 
conjunction with the iterate function.
}
\examples{
library(ExperimentHub)
eh = ExperimentHub()
eh_query = query(eh, c("multiWGCNAdata"))
astrocyte_networks = eh_query[["EH8222"]]
results = list()
results$overlaps = iterate(astrocyte_networks, overlapComparisons, plot=FALSE)

}
\author{
Dario Tommasini
}
