% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_musica.R
\name{name_signatures}
\alias{name_signatures}
\title{Rename signatures for a model}
\usage{
name_signatures(
  musica,
  model_id,
  name_vector,
  modality = "SBS96",
  result_name = "result"
)
}
\arguments{
\item{musica}{A \code{\linkS4class{musica}} object containing a mutational
signature discovery or prediction.}

\item{model_id}{The name of the model to rename signatures for.}

\item{name_vector}{Vector of user-defined signature names}

\item{modality}{The modality of the model. Must be "SBS96", "DBS78", or
"IND83". Default \code{"SBS96"}.}

\item{result_name}{Name of the result list entry containing the model.
Default \code{"result"}.}
}
\value{
Musica object with user-defined signatures names
}
\description{
Rename signatures for a model
}
\examples{
data(res)
name_signatures(res,
  model_id = "res",
  name_vector = c("smoking", "apobec", "unknown")
)
}
