% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ncdfIO.R
\name{save_ncfs}
\alias{save_ncfs}
\alias{load_ncfs}
\title{save/load a ncdfFlowSet object to/from disk.}
\usage{
save_ncfs(
  ncfs,
  path,
  overwrite = FALSE,
  cdf = c("copy", "move", "link", "skip", "symlink")
)

load_ncfs(path)
}
\arguments{
\item{ncfs}{A \code{ncdfFlowSet}}

\item{path}{A character scalar giving the path to save/load the ncdfFlowSet to/from.}

\item{overwrite}{A logical scalar specifying whether to overwrite the existing folder.}

\item{cdf}{a character scalar. The valid options are :"copy","move","skip","symlink","link" specifying what to do with the cdf data file.
Sometime it is more efficient to move or create a link of the existing cdf file to the archived folder.}
}
\value{
\code{load_ncfs} returns a ncdfFlowSet object
}
\description{
The \code{ncdfFlowSet} object contains two parts: R object and cdf file.
Save/load a ncdfFlowSet mainly involves the R part using saveRDS/readRDS.
}
\examples{
\dontrun{
	#ncfs is a ncdfFlowSet
	save_ncfs(fs, path = "tempFolder")
	fs1 <- load_ncfs(path = "tempFolder")

}
}
\seealso{
\code{\link{ncdfFlowSet-class}}
}
