% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixglasso.R
\name{mixglasso_init}
\alias{mixglasso_init}
\title{mixglasso_init}
\usage{
mixglasso_init(x, n.comp, lambda, u.init, mix.prob.init, gamma = 0.5,
  pen = "glasso.parcor", penalize.diagonal = FALSE, term = 10^{    
  -3 }, miniter = 5, maxiter = 1000, min.compsize = 5,
  show.trace = FALSE)
}
\arguments{
\item{x}{Input data matrix}

\item{n.comp}{Number of mixture components}

\item{lambda}{Regularization parameter}

\item{u.init}{Initial responsibilities}

\item{mix.prob.init}{Initial component probablities}

\item{gamma}{Determines form of penalty}

\item{pen}{Determines form of penalty: glasso.parcor (default), glasso.invcov, glasso.invcor}

\item{penalize.diagonal}{Should the diagonal of the inverse covariance matrix be penalized ? Default=FALSE (recommended)}

\item{term}{Termination criterion of EM algorithm. Default=10^-3}

\item{miniter}{Minimal number of EM iteration before 'stop EM if any(compsize)<min.compsize' applies. Default=5}

\item{maxiter}{Maximal number of EM iteration. Default=1000}

\item{min.compsize}{Stop EM if any(compsize)<min.compsize; Default=5}

\item{show.trace}{Should information during execution be printed ? Default=FALSE}
}
\value{
list consisting of
\item{mix.prob}{Component probabilities}
\item{Mu}{Component specific mean vectors}
\item{Sig}{Component specific covariance matrices}
\item{SigInv}{Component specific inverse covariance matrices}
\item{iter}{Number of EM iterations}
\item{loglik}{Log-likelihood}
\item{bic}{-loglik+log(n)*DF/2}
\item{mmdl}{-loglik+penmmdl/2}
\item{u}{Component responsibilities}
\item{comp}{Component assignments}
\item{compsize}{Size of components}
\item{pi.comps}{Component probabilities}
\item{warn}{Warnings during EM algorithm}
}
\description{
mixglasso_init (initialization and lambda set by user)
}
\details{
This function runs mixglasso; requires initialization (u.init,mix.prob.init)
}
\author{
n.stadler
}
