% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FastqcData.R
\docType{class}
\name{FastqcData-class}
\alias{FastqcData-class}
\alias{FastqcData}
\title{The FastqcData Object Class}
\usage{
FastqcData(x)
}
\arguments{
\item{x}{Path to a single zip archive or extracted folder for a individual
FastQC report.}
}
\value{
An object of class FastqcData
}
\description{
The FastqcData Object Class
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
}
\details{
This object class is the main object required for generating plots
and tables. Instantiation will first test for a compressed file (or
extracted directory) with the correct data structure, and will then parse
all the data into R as a \code{FastqcData} object. FastQC modules are
contained as individual slots, which can be viewed using \code{slotNames}.

Individual modules can be returned using the function \code{getModule()}
and specifying which module is required. See \code{\link[=getModule]{getModule()}} for
more details.
}
\section{Slots}{

\describe{
\item{\code{Summary}}{Summary of PASS/WARN/FAIL status for each module}

\item{\code{Basic_Statistics}}{The Basic_Statstics table from the top of a FastQC
html report}

\item{\code{Per_base_sequence_quality}}{The underlying data from the
Per_base_sequence_quality module}

\item{\code{Per_sequence_quality_scores}}{The underlying data from the
Per_sequence_quality_scores module}

\item{\code{Per_base_sequence_content}}{The underlying data from the
Per_base_sequence_content module}

\item{\code{Per_sequence_GC_content}}{The underlying data from the
Per_sequence_GC_content module}

\item{\code{Per_base_N_content}}{The underlying data from the
Per_base_N_content module}

\item{\code{Sequence_Length_Distribution}}{The underlying data from the
Sequence_Length_Distribution module}

\item{\code{Sequence_Duplication_Levels}}{The underlying data from the
Sequence_Duplication_Levels module}

\item{\code{Overrepresented_sequences}}{The underlying data from the
Overrepresented_sequences module}

\item{\code{Adapter_Content}}{The underlying data from the Adapter_Content module}

\item{\code{Kmer_Content}}{The underlying data from the Kmer_Content module}

\item{\code{Total_Deduplicated_Percentage}}{Estimate taken from the plot data for
Sequence_Duplication_Levels. Only included in later versions of FastQC}

\item{\code{version}}{The version of FastQC used for generation of the report (if
available)}

\item{\code{path}}{Path to the FastQC report}
}}

\examples{

# Get the files included with the package
packageDir <- system.file("extdata", package = "ngsReports")
fl <- list.files(packageDir, pattern = "fastqc.zip", full.names = TRUE)[1]

# Load the FASTQC data as a FastqcData object
fd <- FastqcData(fl)
fd

}
