% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multivariate.R
\name{fit_rf}
\alias{fit_rf}
\title{Fit Random Forest}
\usage{
fit_rf(
  object,
  y,
  all_features = FALSE,
  covariates = NULL,
  importance = TRUE,
  assay.type = NULL,
  ...
)
}
\arguments{
\item{object}{a \code{
\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}
object}

\item{y}{character, column name of pheno data giving the dependent variable 
of the model}

\item{all_features}{logical, should all features be included in the model? 
if FALSE, flagged features are left out}

\item{covariates}{character, column names of pheno data
to use as covariates in the model, in addition to molecular features}

\item{importance}{Should importance of features be assessed?}

\item{assay.type}{character, assay to be used in case of multiple assays}

\item{...}{other parameters passed to 
\code{\link[randomForest]{randomForest}}}
}
\value{
An object of class randomForest.
}
\description{
Fits a random forest, where given response column in pheno data is predicted 
using the features. Can be used both for classification and regression. For 
more information, see the documentation of 
\code{\link[randomForest]{randomForest}}.
After fitting the random forest, use \code{\link{importance_rf}} as a 
shortcut for getting the feature importance in random forest prediction.
}
\examples{
data(toy_notame_set, package = "notame")
rf <- fit_rf(toy_notame_set, y = "Group")
rf
importance_rf(rf)

}
\seealso{
\code{\link[randomForest]{randomForest}}, 
\code{\link{importance_rf}}
}
