% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effect_heatmap.R
\name{plot_effect_heatmap}
\alias{plot_effect_heatmap}
\title{Heatmap of effects between variables, such as correlations}
\usage{
plot_effect_heatmap(
  data,
  x,
  y,
  effect,
  p = NULL,
  p_limit = 0.1,
  point_size_range = c(1, 6),
  log2_effect = FALSE,
  discretize_effect = FALSE,
  breaks = 5,
  clustering = TRUE,
  dist_method = "euclidean",
  clust_method = "ward.D2",
  lower_tri = FALSE,
  reverse_y = TRUE,
  use_coord_fixed = TRUE,
  symmetric_aspect_ratio = TRUE,
  title = NULL,
  subtitle = NULL,
  fill_scale = NA
)
}
\arguments{
\item{data}{a data frame with x and y variables and the effect}

\item{x, y}{the column names of data with the x and y variables}

\item{effect}{the column name of the effect, e.g. correlation}

\item{p}{optional, the column name with p-values. If provided, points that 
scale by p-value are drawn on top of the heatmap tiles}

\item{p_limit}{numeric, only p-values below the limit are plotted as points}

\item{point_size_range}{a numeric vector of length 2. The upper and lower 
limits for the point sizes. This needs to be adjusted to make the point size 
look good when compared to the tiles}

\item{log2_effect}{logical, whether the effect should be plotted on a 
logarithmic scale (in case of fold change etc.)}

\item{discretize_effect}{logical, whether the effect range should be divided 
into discrete levels instead of using a continuous scale. Can sometimes make 
patterns more visible, but the hard limits can blur the big picture as well.}

\item{breaks}{if \code{discretize_effect = TRUE}, either the number of 
breaks or the points where to cut for the levels, see \code{\link{cut}}}

\item{clustering}{logical, whether the order of rows and columns should be 
ordered by hierarchical clustering?}

\item{dist_method}{distance method used in clustering, see \code{\link{dist}}}

\item{clust_method}{clustering method used in clustering, see 
\code{\link{hclust}}}

\item{lower_tri}{logical, should only the lower triangular be plotted?}

\item{reverse_y}{logical, if \code{clustering = FALSE, lower_tri = FALSE}, 
should the order of the y-axis
be reversed so that the diagonal is from top left to bottom right?}

\item{use_coord_fixed}{logical, should the heatmap tiles be squares?
If yes, this uses \code{\link[ggplot2]{coord_fixed}}}

\item{symmetric_aspect_ratio}{logical, should the plot panel be a square?
If yes, uses ggplot2::theme(aspect.ratio = 1).}

\item{title, subtitle}{the title and subtitle of the plot}

\item{fill_scale}{fill scale for the heatmap as returned by a ggplot 
function. Set to NA to choose the appropriate scale based on the class of 
the effect variable.}
}
\value{
A ggplot object.
}
\description{
Draws a heatmap of e.g. correlations between variables 
(see perform_correlation_tests).
It is possible to draw only the lower triangular of the heatmap, order rows 
and columns with hierarchical clustering, and add circles for p-values.
}
\details{
All missing effects between variables are replaced by 0 before 
clustering, since \code{hclust} can't deal with missing values.
}
\examples{
data(toy_notame_set, package = "notame")
# Compute correlations between variables
correlations <- notameStats::perform_correlation_tests(toy_notame_set,
  x = rownames(toy_notame_set),
  duplicates = TRUE
)

# Minimal example
plot_effect_heatmap(correlations, 
x = "X", y = "Y", effect = "Correlation_coefficient")

# Lower triangular with discrete effect and p-value dots
plot_effect_heatmap(correlations,
  x = "X", y = "Y", effect = "Correlation_coefficient",
  p = "Correlation_P", point_size_range = c(2, 8),
  discretize_effect = TRUE, breaks = 7, lower_tri = TRUE
)

}
\seealso{
\code{\link{cut}} for discretizing the effect, \code{\link{dist}} 
for distance calculation for clustering,
\code{\link{hclust}} for hierarchical clustering.
}
