% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scatter.R
\name{plot_tsne}
\alias{plot_tsne}
\title{t-SNE scatter plot}
\usage{
plot_tsne(
  object,
  all_features = FALSE,
  center = TRUE,
  scale = "uv",
  perplexity = 30,
  pca_method = "nipals",
  color = NULL,
  shape = color,
  label = NULL,
  density = FALSE,
  title = "t-SNE",
  subtitle = paste("Perplexity:", perplexity),
  color_scale = NA,
  shape_scale = getOption("notame.shape_scale"),
  fill_scale = getOption("notame.fill_scale_dis"),
  text_base_size = 14,
  point_size = 2,
  assay.type = NULL,
  ...
)
}
\arguments{
\item{object}{a \code{
\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}
object}

\item{all_features}{logical, should all features be used? If FALSE (the 
default), flagged features are removed before visualization.}

\item{center}{logical, should the data be centered prior to PCA? (usually 
yes)}

\item{scale}{scaling used, as in \code{\link[pcaMethods]{prep}}. Default is 
'"uv" for unit variance}

\item{perplexity}{the perplexity used in t-SNE}

\item{pca_method}{the method used in PCA if there are missing values}

\item{color}{character, name of the column used for coloring the points. Set 
to NULL for black color.}

\item{shape}{character, name of the column used for shape. Set to NULL for 
uniform round shapes.}

\item{label}{character, name of the column used for point labels}

\item{density}{logical, whether to include density plots to both axes.
The density curves will be split and colored by the 'color' variable.}

\item{title, subtitle}{the titles of the plot}

\item{color_scale}{the color scale as returned by a ggplot function.
Set to NA to choose the appropriate scale based on the class of the coloring 
variable.}

\item{shape_scale}{the shape scale as returned by a ggplot function}

\item{fill_scale}{the fill scale used for density curves.
If a continuous variable is used as color, density curve will be colorless.}

\item{text_base_size}{numeric, base size for text}

\item{point_size}{numeric, size of the points}

\item{assay.type}{character, assay to be used in case of multiple assays}

\item{...}{additional arguments passed to \code{\link[Rtsne]{Rtsne}}}
}
\value{
A ggplot object. If \code{density} is \code{TRUE}, the plot will 
consist of multiple parts and is harder to modify.
}
\description{
Computes t-SNE into two dimensions and plots the map points.
In case there are missing values, PCA is performed using the nipals method 
of \code{\link[pcaMethods]{pca}}, the method can be changed to "ppca" if 
nipals fails.
}
\examples{
data(toy_notame_set, package = "notame")
plot_tsne(toy_notame_set, color = "Time", shape = "Group", perplexity = 10)

}
\seealso{
\code{\link[Rtsne]{Rtsne}}
}
