% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_constructor.R
\name{join_colData}
\alias{join_colData}
\title{Join new columns to pheno data}
\usage{
join_colData(object, dframe)
}
\arguments{
\item{object}{a \code{
\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}
object}

\item{dframe}{a data frame with the new information}
}
\value{
A SummarizedExperiment object with the new information added to 
colData(object).
}
\description{
Join a new data frame of information to pheno data of a SummarizedExperiment 
object.
}
\examples{
data(toy_notame_set)
new_info <- data.frame(
  Sample_ID = colnames(toy_notame_set),
  BMI = stats::runif(ncol(toy_notame_set), 22, 26)
)
with_new_info <- join_colData(toy_notame_set, new_info)
colnames(colData(with_new_info))

}
