% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotPeaks.R
\name{plotPeaks}
\alias{plotPeaks}
\alias{plotPeaks,numeric-method}
\alias{plotPeaks,data.frame-method}
\alias{plotPeaks,GRanges-method}
\alias{plotPeaks,IRanges-method}
\title{Nucleosome calling plot function}
\usage{
plotPeaks(peaks, data, ...)

\S4method{plotPeaks}{numeric}(
  peaks,
  data,
  threshold = 0,
  scores = NULL,
  start = 1,
  end = length(data),
  xlab = "position",
  ylab = "coverage",
  type = 1,
  col.points = "red",
  thr.lty = 1,
  thr.lwd = 1,
  thr.col = "darkred",
  scor.col = col.points,
  scor.cex = 2.5,
  scor.digits = 2,
  scor.nudge = 2000
)

\S4method{plotPeaks}{data.frame}(peaks, data, ...)

\S4method{plotPeaks}{GRanges}(peaks, data, ...)

\S4method{plotPeaks}{IRanges}(
  peaks,
  data,
  threshold = 0,
  scores = NULL,
  start = 1,
  end = length(data),
  dyn.pos = TRUE,
  xlab = "position",
  ylab = "coverage",
  type = 1,
  col.points = "red",
  thr.lty = 1,
  thr.lwd = 1,
  thr.col = "darkred",
  rect.thick = 2,
  rect.lwd = 0.5,
  rect.border = "black",
  scor.col = col.points,
  scor.cex = 2.5,
  scor.digits = 2,
  indiv.scores = FALSE,
  scor.nudge = 2000
)
}
\arguments{
\item{peaks}{\code{numeric}, \code{data.frame}, \code{IRanges} or \code{GRanges} object
containing the detected peaks information. See help of \code{\link[=peakDetection]{peakDetection()}}
or \code{\link[=peakScoring]{peakScoring()}} for more details.}

\item{data}{Coverage or Tiling Array intensities}

\item{\dots}{Arguments to be passed to other methods.}

\item{threshold}{Threshold applied in \code{peakDetection}}

\item{scores}{If \code{peaks} is a \code{data.frame} or a \code{GRanges} it's obtained from
'score' column, otherwise, \code{scores} can be given here as a \code{numeric}
vector.}

\item{start, end}{Start and end points defining a subset in the range of
\code{data}. This is a convenient way to plot only a small region of data,
without dealing with subsetting of range or score objects.}

\item{xlab, ylab, type, col.points}{Default values with general properties of
the plot}

\item{thr.lty, thr.lwd, thr.col}{Default values with general properties for
threshold representation}

\item{scor.col, scor.nudge, scor.cex, scor.digits}{Default values for
\code{\link[ggplot2:geom_text]{ggplot2::geom_text()}} representation for score numbers, if available.}

\item{dyn.pos}{If peaks are ranges, should they be positioned dynamicaly on
top of the peaks or staticaly at \code{threshold} baseline. Spacing of
overlapping ranges is automatically applied if \code{FALSE}.}

\item{rect.thick, rect.lwd, rect.border}{Default values for
\code{\link[ggplot2:geom_rect]{ggplot2::geom_rect()}} representation of ranges. \code{rect.thick} indicates
the thickness of the rectangles.}

\item{indiv.scores}{Show or hide individual scores for width and height in
brakets besides the mixed score.}
}
\value{
(none)
}
\description{
Helper function for a quick and convenient overview of nucleosome calling
data.
}
\details{
This function is intended to plot data previously processed with \code{nucleR}
pipeline. It shows a coverage/intensity profile toghether with the
identified peaks. If available, score of each peak is also shown.
}
\examples{

# Generate a random peaks profile
reads <- syntheticNucMap(nuc.len=40, lin.len=130)$syn.reads
cover <- coverage.rpm(reads)

# Filter them
cover_fft <- filterFFT(cover)

# Detect peaks
peaks <- peakDetection(cover_fft, threshold="40\%", score=TRUE, width=140)

# Plot peaks and coverage profile (show only a window)
plotPeaks(peaks, cover_fft, threshold="40\%", start=1000, end=6000)

}
\seealso{
\code{\link[=peakDetection]{peakDetection()}}, \code{\link[=peakScoring]{peakScoring()}}, \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}},
}
\author{
Ricard Illa \email{ricard.illa@irbbarcelona.org}
}
\keyword{hplot}
