% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/methods-matchRanges.R
\name{matchitToMatched}
\alias{matchitToMatched}
\alias{matchitToMatched,matchit-method}
\title{Coerce \code{matchit} to \code{Matched} object}
\usage{
matchitToMatched(x, ranges = NULL, keep_mcols = TRUE)

\S4method{matchitToMatched}{matchit}(x, ranges = NULL, keep_mcols = TRUE)
}
\arguments{
\item{x}{A \code{matchit} object from \code{MatchIt} package.}

\item{ranges}{A \code{GRanges} or \code{GInteractions} object
that is the same length as the data used to create
the \code{matchit} object, \code{x}.}

\item{keep_mcols}{Logical whether to keep or existing
mcols of the object supplied in \code{ranges} or not.
Default is TRUE.}
}
\value{
A \code{Matched} subclass object, depending on the
value of \code{ranges}. If \code{is(ranges, "GRanges")} then a
\code{MatchedGRanges} object is returned. If
\code{is(ranges, "GInteractions")} then a \code{MatchedGInteractions}
object is returned. If \code{is.null(ranges)} then a
the function first attempts to coerce into the other
classes before coercing to \code{MatchedDataFrame}.
}
\description{
Coerce \code{matchit} to \code{Matched} object
}
\examples{
\donttest{
if (!requireNamespace("MatchIt", quietly=TRUE)) {
 set.seed(123)
 x <- makeExampleMatchedDataSet(type="GRanges")
 
 ## Convert GRanges to data.frame, pass to matchit,
 ## and convert to MatchedGRanges object
 set.seed(123)
 mgr <- 
   as.data.frame(x) |>
   matchit(formula=feature1 ~ feature2 + feature3,
           data=_,
           method='nearest',
           replace=FALSE) |>
   matchitToMatched()
 
 ## Compatible with GRanges & Matched functions
 mgr
 plotCovariate(mgr)
} else {
 message("The 'MatchIt' package is required to run this example.")
}
} 

}
