% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oncoMix_two_component_mixture_models.R
\name{mixModelParams}
\alias{mixModelParams}
\title{Generate the parameters for two 2-component Gaussian mixture models
with equal variances}
\usage{
mixModelParams(exprNml, exprTum)
}
\arguments{
\item{exprNml}{A dataframe (S3 or S4), matrix, or SummarizedExperiment object
containing normal data with patients as columns and genes as rows.}

\item{exprTum}{A dataframe (S3 or S4), matrix, or SummarizedExperiment object
containing tumor data with patients as columns and genes as rows.}
}
\value{
Returns a dataframe, each element of which contains the 12 mixture
model parameters for each gene in an n x 12 matrix, where n is the number
of genes.
}
\description{
This function allows you to generate the parameters for two 2-component
Gaussian mixture model with equal variances from 2 matrices of data with
a priori labels (eg tumor vs normal.) This application was originally
intended for matrices of gene expression data treated with 2 conditions.
}
\examples{
exprNml <- as.data.frame(matrix(data=rgamma(n=150, shape=2, rate=2),
nrow=10, ncol=15))
colnames(exprNml) <- paste0("patientN", seq_len(ncol(exprNml)))
rownames(exprNml) <- paste0("gene", seq_len(nrow(exprNml)))

exprTum <- as.data.frame(matrix(data=rgamma(n=150, shape=4, rate=3),
nrow=10, ncol=15))
colnames(exprTum) <- paste0("patientT", seq_len(ncol(exprTum)))
rownames(exprTum) <- paste0("gene", seq_len(nrow(exprTum)))

mmParams <- mixModelParams(exprNml, exprTum)
}
\keyword{mixture-model,}
\keyword{oncomix,}
\keyword{two-component}
